/*
 * Decompiled with CFR 0.152.
 */
package PizzaLoverAgent;

import PizzaLoverAgent.State;
import java.util.Comparator;
import logist.task.Task;
import logist.task.TaskSet;
import logist.topology.Topology;

public class Node
implements Comparator,
Comparable {
    private State state;
    private Node parent;
    private double cost;

    public Node(State state, Node parent, double cost) {
        this.state = state;
        this.parent = parent;
        this.cost = cost;
    }

    public boolean equals(Node n) {
        return this.state.equals(n.state);
    }

    public int compareTo(Node o) {
        return this.compare(this, o);
    }

    public int compare(Node n1, Node n2) {
        return this.betterTie2(n1, n2);
    }

    public int naiveTie(Node n1, Node n2) {
        double f2;
        double f1 = this.f(n1);
        if (f1 > (f2 = this.f(n2))) {
            return 1;
        }
        return f1 >= f2 ? 0 : -1;
    }

    public int betterTie(Node n1, Node n2) {
        double f2;
        double f1 = this.f(n1);
        if (f1 > (f2 = this.f(n2))) {
            return 1;
        }
        if (f1 < f2) {
            return -1;
        }
        if (this.g(n1) > this.g(n2)) {
            return 1;
        }
        return this.g(n1) >= this.g(n2) ? 0 : -1;
    }

    public int betterTie2(Node n1, Node n2) {
        double f2;
        double f1 = this.f(n1);
        if (f1 > (f2 = this.f(n2))) {
            return 1;
        }
        if (f1 < f2) {
            return -1;
        }
        if (this.g(n1) > this.g(n2)) {
            return -1;
        }
        return this.g(n1) >= this.g(n2) ? 0 : 1;
    }

    public int bestTie(Node n1, Node n2) {
        double f2;
        double f1 = this.f(n1);
        if (f1 > (f2 = this.f(n2))) {
            return 1;
        }
        if (f1 < f2) {
            return -1;
        }
        if (this.g(n1) > this.g(n2)) {
            return -1;
        }
        if (this.g(n1) < this.g(n2)) {
            return 1;
        }
        if (n1.getState().getDelivered().size() < n2.getState().getDelivered().size()) {
            return 1;
        }
        if (n1.getState().getDelivered().size() > n2.getState().getDelivered().size()) {
            return -1;
        }
        if (n1.getState().getCarried().size() < n2.getState().getCarried().size()) {
            return 1;
        }
        return n1.getState().getCarried().size() <= n2.getState().getCarried().size() ? 0 : -1;
    }

    public double f(Node n) {
        return this.g(n) + this.h5(n);
    }

    public double g(Node n) {
        return n.getCost();
    }

    public double naiveH(Node n) {
        return 0.0;
    }

    public double h1(Node n) {
        double max = 0.0;
        State s = n.getState();
        Topology.City current = s.getCity();
        TaskSet carried = s.getCarried();
        for (Task task : carried) {
            double dist = current.distanceTo(task.deliveryCity);
            max = Math.max(dist, max);
        }
        TaskSet delivered = s.getDelivered();
        TaskSet alreadyPickedUp = TaskSet.union((TaskSet)carried, (TaskSet)delivered);
        TaskSet toBePickedUp = TaskSet.intersectComplement((TaskSet)s.getTasks(), (TaskSet)alreadyPickedUp);
        for (Task task : toBePickedUp) {
            double dist = current.distanceTo(task.pickupCity) + task.pickupCity.distanceTo(task.deliveryCity);
            max = Math.max(dist, max);
        }
        return max;
    }

    public double h2(Node n) {
        double max = 0.0;
        State s = n.getState();
        Topology.City current = s.getCity();
        TaskSet carried = s.getCarried();
        for (Task task : carried) {
            double dist = current.distanceTo(task.deliveryCity);
            max = Math.max(dist, max);
        }
        return max;
    }

    public double h3(Node n) {
        double max = 0.0;
        State s = n.getState();
        Topology.City current = s.getCity();
        TaskSet carried = s.getCarried();
        TaskSet delivered = s.getDelivered();
        TaskSet alreadyPickedUp = TaskSet.union((TaskSet)carried, (TaskSet)delivered);
        TaskSet toBePickedUp = TaskSet.intersectComplement((TaskSet)s.getTasks(), (TaskSet)alreadyPickedUp);
        for (Task task : toBePickedUp) {
            double dist = current.distanceTo(task.pickupCity) + task.pickupCity.distanceTo(task.deliveryCity);
            max = Math.max(dist, max);
        }
        return max;
    }

    public double h4(Node n) {
        double max = 0.0;
        State s = n.getState();
        Topology.City current = s.getCity();
        TaskSet carried = s.getCarried();
        TaskSet delivered = s.getDelivered();
        TaskSet alreadyPickedUp = TaskSet.union((TaskSet)carried, (TaskSet)delivered);
        TaskSet toBePickedUp = TaskSet.intersectComplement((TaskSet)s.getTasks(), (TaskSet)alreadyPickedUp);
        for (Task task : toBePickedUp) {
            double dist = current.distanceTo(task.pickupCity);
            max = Math.max(dist, max);
        }
        return max;
    }

    public double h5(Node n) {
        double max = 0.0;
        State s = n.getState();
        TaskSet carried = s.getCarried();
        TaskSet delivered = s.getDelivered();
        TaskSet alreadyPickedUp = TaskSet.union((TaskSet)carried, (TaskSet)delivered);
        TaskSet toBePickedUp = TaskSet.intersectComplement((TaskSet)s.getTasks(), (TaskSet)alreadyPickedUp);
        for (Task task : toBePickedUp) {
            double dist = task.pickupCity.distanceTo(task.deliveryCity);
            max = Math.max(dist, max);
        }
        return max;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public int compare(Object obj, Object obj1) {
        return this.compare((Node)obj, (Node)obj1);
    }

    public int compareTo(Object obj) {
        return this.compareTo((Node)obj);
    }
}

