/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task.distribution.function;

import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.distribution.function.IFunction;
import epfl.lia.logist.tools.Convert;
import java.util.Properties;
import org.apache.commons.math.random.RandomDataImpl;

public class UniformDensityFunction
implements IFunction {
    private double mMin = 0.0;
    private double mMax = 1.0;
    private long mSeed = 0L;
    private RandomDataImpl mRandom = null;

    public UniformDensityFunction() {
        this.mMin = 0.0;
        this.mMax = 1.0;
        this.mSeed = System.currentTimeMillis();
        this.mRandom = new RandomDataImpl();
        this.mRandom.reSeed(this.mSeed);
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Uniform density function seed value is " + this.mSeed + " !");
    }

    public UniformDensityFunction(Properties props) {
        this.mMin = Convert.toDouble(props.getProperty("min"), 0.0);
        this.mMax = Convert.toDouble(props.getProperty("max"), 1.0);
        this.mSeed = Convert.toLong(props.getProperty("seed"), System.currentTimeMillis());
        this.mRandom = new RandomDataImpl();
        this.mRandom.reSeed(this.mSeed);
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Uniform density function seed value is " + this.mSeed + " !");
    }

    public double nextValue() {
        return this.mRandom.nextUniform(this.mMin, this.mMax);
    }
}

