/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task.distribution.function;

import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.distribution.function.IFunction;
import epfl.lia.logist.tools.Convert;
import java.util.Properties;
import org.apache.commons.math.random.RandomDataImpl;

public class NormalDensityFunction
implements IFunction {
    private double mMean = 0.0;
    private double mDeviation = 0.0;
    private double[] mYB;
    private RandomDataImpl mRandom = null;
    private long mSeed = 0L;

    public NormalDensityFunction() {
        this.mYB = new double[]{0.0, 1.0};
        this.mMean = 0.0;
        this.mDeviation = 0.4472135954999579;
        this.mSeed = System.currentTimeMillis();
        this.mRandom = new RandomDataImpl();
        this.mRandom.reSeed(this.mSeed);
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Normal density function seed value is " + this.mSeed + " !");
    }

    public NormalDensityFunction(Properties props) {
        this.mYB = new double[]{Convert.toDouble(props.getProperty("y-min"), 0.0), Convert.toDouble(props.getProperty("y-max"), 1.0)};
        this.mMean = Convert.toDouble(props.getProperty("mean"), 0.0);
        double variance = Convert.toDouble(props.getProperty("variance"), -1.0);
        if (variance < 0.0) {
            this.mDeviation = Convert.toDouble(props.getProperty("deviation"), -1.0);
            if (this.mDeviation <= 0.0) {
                this.mDeviation = 0.4472135954999579;
            }
        } else {
            this.mDeviation = Math.sqrt(variance);
        }
        this.mSeed = Convert.toLong(props.getProperty("seed"), System.currentTimeMillis());
        this.mRandom = new RandomDataImpl();
        this.mRandom.reSeed(this.mSeed);
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Normal density function seed value is " + this.mSeed + " !");
    }

    public double nextValue() {
        double y = this.mRandom.nextGaussian(this.mMean, this.mDeviation);
        return this.mYB[0] + (this.mYB[1] - this.mYB[0]) * y;
    }
}

