/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task;

import epfl.lia.logist.agent.AgentManager;
import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.IService;
import epfl.lia.logist.core.listeners.IAgentListener;
import epfl.lia.logist.core.listeners.ITopologyListener;
import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.task.ProbabilityDistribution;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.TaskGenerator;
import epfl.lia.logist.task.TasksetDescriptor;
import epfl.lia.logist.tools.AID;
import epfl.lia.logist.tools.LogistGlobals;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager
implements IService,
IAgentListener,
ITopologyListener {
    private TaskGenerator mTaskGen = null;
    private static TaskManager msSingleton = null;
    private Topology mTopology = null;
    private LogManager mLogMgr = null;
    private HashMap<Integer, Task> mMapOfTasks = null;
    private HashMap<String, ArrayList<Task>> mMapOfTasksToPickup = null;
    private HashMap<String, ArrayList<Task>> mMapOfDeliveredTasks = null;
    private HashMap<AID, ArrayList<Task>> mMapOfAllocations = null;
    private int mNumOfAllocatedTasks = 0;
    private int mNumOfFreeTasks = 0;
    private int mTotalTaskCount = 0;
    private int mTotalDeliveredTasks = 0;
    private LogistGlobals mGlobals = null;

    public TaskManager(Topology tp) {
        if (msSingleton == null) {
            msSingleton = this;
        }
        this.mMapOfTasksToPickup = new HashMap();
        this.mMapOfDeliveredTasks = new HashMap();
        this.mMapOfAllocations = new HashMap();
        this.mMapOfTasks = new HashMap();
        this.mTopology = tp;
        this.mLogMgr = LogManager.getInstance();
    }

    protected synchronized void dispatchTasks(ArrayList<Task> tasks) {
        this.mTotalTaskCount += tasks.size();
        this.mNumOfFreeTasks += tasks.size();
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        for (Task t : tasks) {
            this.mMapOfTasks.put(t.getID(), t);
            ArrayList<Task> taskList = this.mMapOfTasksToPickup.get(t.getPickupCity());
            if (taskList == null) continue;
            taskList.add(t);
        }
    }

    public synchronized Task allocate(int taskID, City c, AID aid) {
        Task task = null;
        assert (c != null);
        ArrayList<Task> taskList = this.mMapOfTasksToPickup.get(c.getNodeLabel());
        assert (taskList != null);
        for (Task t : taskList) {
            if (taskID != t.getID()) continue;
            task = t;
            taskList.remove(t);
            break;
        }
        if (task == null) {
            return null;
        }
        ArrayList<Task> allocationList = this.mMapOfAllocations.get(aid);
        assert (allocationList != null);
        allocationList.add(task);
        --this.mNumOfFreeTasks;
        ++this.mNumOfAllocatedTasks;
        return task;
    }

    public HashMap<Integer, Boolean> allocateRange(int from, int to, AID agentID) {
        return null;
    }

    public HashMap<Integer, Boolean> allocateFull(AID agentID) {
        return null;
    }

    public double deliverTask(AID aid, String agentName, Integer taskID) {
        ArrayList<Task> allocationList = this.getAllocatedTasklist(aid);
        assert (allocationList != null);
        int allocatedIndex = -1;
        int currentTaskIndex = 0;
        for (Task at : allocationList) {
            if (at != null && at.getID() == taskID.intValue()) {
                allocatedIndex = currentTaskIndex;
                break;
            }
            ++currentTaskIndex;
        }
        if (allocatedIndex == -1) {
            return -1000.0;
        }
        Task task = allocationList.remove(currentTaskIndex);
        assert (task != null);
        task.setDelivered(true, agentName);
        ArrayList<Task> deliveryList = this.mMapOfDeliveredTasks.get(task.getDeliveryCity());
        assert (deliveryList != null);
        deliveryList.add(task);
        ++this.mTotalDeliveredTasks;
        --this.mNumOfAllocatedTasks;
        return task.getRewardPerKm();
    }

    public void releaseTasks(AID agentID) {
        ArrayList<Task> allocationList = this.mMapOfAllocations.get(agentID);
        if (allocationList == null || allocationList.isEmpty()) {
            return;
        }
        this.mNumOfFreeTasks += allocationList.size();
        for (Task t : allocationList) {
            ArrayList<Task> taskList = this.mMapOfTasksToPickup.get(t.getPickupCity());
            if (taskList == null) continue;
            taskList.add(t);
        }
    }

    public synchronized ArrayList<Task> getTaskList(boolean everything) {
        ArrayList<Task> taskList = new ArrayList<Task>();
        for (Task t : this.mMapOfTasks.values()) {
            if (t.getDelivered() && !everything) continue;
            taskList.add(t.clone());
        }
        return taskList;
    }

    public Task getTaskFromID(Integer id) {
        return this.mMapOfTasks.get(id);
    }

    public boolean allTasksDelivered() {
        return this.mTotalDeliveredTasks == this.mTotalTaskCount && this.mTotalTaskCount > 0;
    }

    public void generateMoreTasks() {
        if (this.mTotalTaskCount > 0 && this.mTotalTaskCount - this.mTotalDeliveredTasks <= this.mGlobals.TaskThreshold && this.mTaskGen.hasMoreTasks()) {
            this.dispatchTasks(this.mTaskGen.generate());
            AgentManager.getInstance().notifyTaskBatchCreation();
            this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, String.valueOf(this.mTaskGen.getBatchSize()) + " tasks have been created !");
        }
    }

    public void setGenerator(TaskGenerator tg) {
        this.mTaskGen = tg;
    }

    public TaskGenerator getGenerator() {
        return this.mTaskGen;
    }

    public static TaskManager getInstance() {
        return msSingleton;
    }

    public void create(TasksetDescriptor tsd) throws Exception {
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, "Creating the task generator.");
        this.mTaskGen = new TaskGenerator(tsd.TaskGeneratorDescriptor);
        this.dispatchTasks(this.mTaskGen.generate());
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, "Destroying the task manager...");
        this.writeManagerLog();
    }

    @Override
    public void setup(Configuration cfg, LogistGlobals lg) throws Exception {
        this.create(cfg.Tasks);
        this.mGlobals = lg;
    }

    @Override
    public void reset(int round) {
        this.mTaskGen.reset();
        this.dispatchTasks(this.mTaskGen.generate());
    }

    public int getPickupTaskCount(String city) {
        return this.mMapOfTasksToPickup.get(city).size();
    }

    public int getDeliveredTaskCount(String city) {
        return this.mMapOfDeliveredTasks.get(city).size();
    }

    public ArrayList<Task> getPickupTasklist(String city) {
        return this.mMapOfTasksToPickup.get(city);
    }

    public ArrayList<Task> getAllocatedTasklist(AID aid) {
        return this.mMapOfAllocations.get(aid);
    }

    public ArrayList<Task> getDeliveredTasklist(String city) {
        return this.mMapOfDeliveredTasks.get(city);
    }

    @Override
    public void onCityAddition(City c) {
        if (c == null) {
            return;
        }
        this.mMapOfTasksToPickup.put(c.getNodeLabel(), new ArrayList());
        this.mMapOfDeliveredTasks.put(c.getNodeLabel(), new ArrayList());
    }

    @Override
    public void onCityDeletion(City c) {
        if (c == null) {
            return;
        }
        ArrayList<Task> lTaskList = this.mMapOfTasksToPickup.get(c.getNodeLabel());
        if (lTaskList != null) {
            this.mMapOfTasksToPickup.remove(lTaskList);
        }
        if ((lTaskList = this.mMapOfDeliveredTasks.get(c.getNodeLabel())) != null) {
            this.mMapOfDeliveredTasks.remove(lTaskList);
        }
    }

    @Override
    public void onAgentAddition(AgentProfile ap) {
        if (ap == null) {
            return;
        }
        this.mMapOfAllocations.put(ap.getID(), new ArrayList());
    }

    @Override
    public void onAgentDeletion(AgentProfile ap) {
        if (ap == null) {
            return;
        }
        ArrayList<Task> lTaskList = this.mMapOfAllocations.get(ap.getID());
        if (lTaskList != null) {
            this.mMapOfAllocations.remove(lTaskList);
        }
    }

    public String toString() {
        return "Task management service";
    }

    protected void writeManagerLog() {
        ArrayList<Task> arrayOfTasks;
        FileOutputStream fs = null;
        try {
            fs = new FileOutputStream("logs/task-log.xml");
        }
        catch (Exception e) {
            return;
        }
        PrintStream out = new PrintStream(fs);
        out.println("<xml version=\"1.0\" encoding=\"UTF-8\" />");
        out.println("<log>");
        out.println("\t<probabilities>");
        ProbabilityDistribution pd = this.getGenerator().getDistribution().getProbabilityDistribution();
        if (pd != null) {
            for (City c1 : this.mTopology.getCities().values()) {
                for (City c2 : this.mTopology.getCities().values()) {
                    double dProbability = pd.getProbability(c1, c2);
                    double dReward = pd.getRewardPerKm(c1, c2);
                    out.println("\t\t<probability city1=\"" + c1.getNodeLabel() + "\" city2=\"" + c2.getNodeLabel() + "\" value=\"" + dProbability + "\" reward=\"" + dReward + "\" />");
                }
            }
        }
        out.println("\t</probabilities>");
        out.println("\t<tasks>");
        for (Task t : this.mMapOfTasks.values()) {
            out.println("\t\t" + t);
        }
        out.println("\t</tasks>");
        out.println("\t<delivered>");
        for (String cityName : this.mMapOfDeliveredTasks.keySet()) {
            arrayOfTasks = this.mMapOfDeliveredTasks.get(cityName);
            for (Task t : arrayOfTasks) {
                out.println("\t\t" + t);
            }
        }
        out.println("\t</delivered>");
        out.println("\t<undelivered>");
        for (String cityName : this.mMapOfTasksToPickup.keySet()) {
            arrayOfTasks = this.mMapOfTasksToPickup.get(cityName);
            for (Task t : arrayOfTasks) {
                out.println("\t\t" + t);
            }
        }
        out.println("\t</undelivered>");
        out.println("</log>");
        out.close();
    }
}

