/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.task;

import epfl.lia.logist.task.TaskDescriptor;

public class Task {
    protected int mID;
    protected double mRewardPerKm;
    protected double mWeight;
    protected String mPickupCity;
    protected String mDeliveryCity;
    protected String mAgent = "None";
    protected boolean mDelivered = false;
    private static int mNextID = 0;

    public Task() {
    }

    public Task(TaskDescriptor td) {
        this.mID = mNextID++;
        this.mRewardPerKm = td.RewardPerKm;
        this.mWeight = td.Weight;
        this.mPickupCity = td.PickupCity;
        this.mDeliveryCity = td.DeliveryCity;
    }

    public TaskDescriptor getDescriptor() {
        TaskDescriptor td = new TaskDescriptor();
        td.ID = this.mID;
        td.RewardPerKm = this.mRewardPerKm;
        td.Weight = this.mWeight;
        td.PickupCity = this.mPickupCity;
        td.DeliveryCity = this.mDeliveryCity;
        return td;
    }

    public Task clone() {
        Task t = new Task();
        t.mID = this.mID;
        t.mRewardPerKm = this.mRewardPerKm;
        t.mWeight = this.mWeight;
        t.mPickupCity = this.mPickupCity;
        t.mDeliveryCity = this.mDeliveryCity;
        t.mAgent = this.mAgent;
        t.mDelivered = this.mDelivered;
        return t;
    }

    public int getID() {
        return this.mID;
    }

    public double getRewardPerKm() {
        return this.mRewardPerKm;
    }

    public void setRewardPerKm(double d) {
        this.mRewardPerKm = d;
    }

    public double getWeight() {
        return this.mWeight;
    }

    public String getPickupCity() {
        return this.mPickupCity;
    }

    public String getDeliveryCity() {
        return this.mDeliveryCity;
    }

    public boolean getDelivered() {
        return this.mDelivered;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Task)) {
            return false;
        }
        Task t = (Task)obj;
        return this.mID == t.getID();
    }

    public void setDelivered(boolean status, String vehicle) {
        this.mDelivered = status;
        this.mAgent = vehicle;
    }

    public String getDeliverAgent() {
        return this.mAgent;
    }

    public String toString() {
        return "<task id=\"" + this.mID + "\" pickup=\"" + this.mPickupCity + "\" delivery=\"" + this.mDeliveryCity + "\" owner=\"" + this.mAgent + "\" weight=\"" + this.mWeight + "\" reward=\"" + this.mRewardPerKm + "\" />";
    }
}

