/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.core.view;

import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.IService;
import epfl.lia.logist.core.view.AgentView;
import epfl.lia.logist.core.view.TaskView;
import epfl.lia.logist.core.view.TopologyView;
import epfl.lia.logist.tools.LogistGlobals;

public class ModelView
implements IService {
    protected TopologyView mTopoView;
    protected AgentView mAgentView;
    protected TaskView mTaskView;
    protected int mSpaceWidth;
    protected int mSpaceHeight;

    public ModelView(int width, int height) {
        this.mSpaceWidth = width;
        this.mSpaceHeight = height;
        this.mTopoView = new TopologyView(width, height);
        this.mAgentView = new AgentView(width, height);
        this.mTaskView = new TaskView(width, height);
    }

    public void init() {
        this.mTopoView.create();
        this.mTaskView.create();
        this.mAgentView.create();
    }

    public void shutdown() {
        this.mTopoView.destroy();
        this.mTaskView.destroy();
        this.mAgentView.destroy();
    }

    public void setup(Configuration cfg, LogistGlobals lg) {
    }

    public void reset(int round) {
    }

    public Object getCityAt(int posX, int posY) {
        return null;
    }

    public Object getVehicleAt(int posX, int posY) {
        return null;
    }

    public int getNumberOfTasksAt(int posX, int posY) {
        return 0;
    }

    public int getNumberOfDeliveredTasksAt(int posX, int posY) {
        return 0;
    }

    public int getNumberOfNonDeliveredTasksAt(int posX, int posY) {
        return this.getNumberOfTasksAt(posX, posY) - this.getNumberOfDeliveredTasksAt(posX, posY);
    }

    public TopologyView getTopologyView() {
        return this.mTopoView;
    }

    public AgentView getAgentView() {
        return this.mAgentView;
    }

    public TaskView getTaskView() {
        return this.mTaskView;
    }

    public String toString() {
        return "Viewing service";
    }
}

