/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent.state.auction;

import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.agent.AgentStateEnum;
import epfl.lia.logist.agent.plan.AgentActionTypeEnum;
import epfl.lia.logist.agent.plan.GPickupAction;
import epfl.lia.logist.agent.plan.IGenericAction;
import epfl.lia.logist.agent.plan.Plan;
import epfl.lia.logist.agent.state.AgentState;
import epfl.lia.logist.agent.state.CompanyAgentState;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.messaging.action.Action;
import epfl.lia.logist.messaging.action.ActionTypeEnum;
import epfl.lia.logist.messaging.action.BidAction;
import epfl.lia.logist.messaging.signal.AuctionNotificationObject;
import epfl.lia.logist.messaging.signal.AuctionSetupObject;
import epfl.lia.logist.messaging.signal.AuctionWonSignal;
import epfl.lia.logist.messaging.signal.InStateObject;
import epfl.lia.logist.messaging.signal.Signal;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.task.distribution.ITaskDistribution;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidderCompanyState
extends CompanyAgentState {
    private ArrayList<Integer> mListOfTasks = null;

    public BidderCompanyState(AgentProfile ap, AgentState as) {
        super(ap, as);
    }

    @Override
    public boolean planMeetsConditions(Plan p) {
        Plan p1 = (Plan)p.clone();
        while (p1.hasMoreElements()) {
            IGenericAction ga = p1.nextElement();
            if (ga.getType() != AgentActionTypeEnum.PICKUP) continue;
            GPickupAction gpa = (GPickupAction)ga;
            Task t = gpa.getTask();
            if (t == null) {
                return false;
            }
            Integer taskID = t.getID();
            if (this.mListOfTasks.contains(taskID)) continue;
            this.warning("[" + this.mProfile.getName() + "] has picked a task " + "which doesn't exist or which belongs to another " + "agent ! Releasing tasks !");
            return false;
        }
        return true;
    }

    @Override
    public void notifySignal(Signal<?> signal) {
        switch (signal.getType()) {
            case SMT_ASKBID: {
                break;
            }
            case SMT_AUCTION_WON: {
                AuctionNotificationObject obj = (AuctionNotificationObject)((AuctionWonSignal)signal).getMessage();
                this.mListOfTasks.add(obj.Task.ID);
                break;
            }
            case SMT_AUCTION_LOST: {
                break;
            }
            case SMT_AUCTION_START: {
                if (this.mListOfTasks == null) {
                    this.mListOfTasks = new ArrayList();
                }
                this.mListOfTasks.clear();
                this.mState = AgentStateEnum.AS_AUCTION_START;
                break;
            }
            case SMT_AUCTION_END: {
                this.mState = AgentStateEnum.AS_AUCTION_END;
            }
        }
    }

    @Override
    protected void execute(Action<?> action) {
        switch (this.mState) {
            case AS_SETUP: {
                AuctionSetupObject aso = new AuctionSetupObject();
                aso.Vehicles = new ArrayList();
                for (AgentProfile ap : this.mProfile.getChildren()) {
                    aso.Vehicles.add(ap.getProperties());
                }
                aso.Topology = Topology.getInstance();
                ITaskDistribution taskDistribution = TaskManager.getInstance().getGenerator().getDistribution();
                aso.Probabilities = taskDistribution.getProbabilityDistribution();
                this.postSetupSignal(aso);
                this.mLastState = AgentStateEnum.AS_SETUP;
                this.mState = AgentStateEnum.AS_WAIT;
                break;
            }
            case AS_IDLE: {
                break;
            }
            case AS_AUCTION_START: {
                if (action == null || action.getType() != ActionTypeEnum.AMT_READY) break;
                this.mState = AgentStateEnum.AS_AUCTION_ITEM;
                break;
            }
            case AS_AUCTION_ITEM: {
                if (action == null) {
                    return;
                }
                if (action.getType() != ActionTypeEnum.AMT_BID) break;
                BidAction ba = (BidAction)action;
                ba = new BidAction(this.getObjectID(), this.mProfile.getParent().getID(), (Double)ba.getMessage());
                this.mDispatcher.post(ba);
                break;
            }
            case AS_AUCTION_END: {
                if (action == null || action.getType() != ActionTypeEnum.AMT_READY) break;
                InStateObject lObject = this.createInStateObject();
                TaskManager taskMgr = TaskManager.getInstance();
                lObject.AssignedTasks.clear();
                for (Integer tid : this.mListOfTasks) {
                    Task t = taskMgr.getTaskFromID(tid);
                    if (t != null) {
                        lObject.AssignedTasks.add(t);
                        continue;
                    }
                    this.warning("Task of ID " + tid + " doesn't exist !");
                }
                this.postInStateSignal(lObject);
                this.mLastState = AgentStateEnum.AS_FINISHED;
                this.mState = AgentStateEnum.AS_WAIT;
                break;
            }
        }
    }
}

