/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.space;

import java.awt.Dimension;
import java.util.Arrays;
import uchicago.src.collection.BaseMatrix;
import uchicago.src.collection.DoubleMatrix;
import uchicago.src.sim.space.Discrete2DSpace;
import uchicago.src.sim.space.Torus;

public class Diffuse2D
implements Discrete2DSpace,
Torus {
    public static final long MAX = 32767L;
    public static final long MIN = -32767L;
    protected double diffCon;
    protected double evapRate;
    protected DoubleMatrix readMatrix;
    protected DoubleMatrix writeMatrix;
    protected int xSize;
    protected int ySize;
    protected int x;
    protected int prevX;
    protected int nextX;
    protected int y;
    protected int prevY;
    protected int nextY;

    public Diffuse2D(int n, int n2) {
        this(1.0, 1.0, n, n2);
    }

    public Diffuse2D(double d, double d2, int n, int n2) {
        this.diffCon = d;
        this.evapRate = d2;
        this.xSize = n;
        this.ySize = n2;
        this.readMatrix = new DoubleMatrix(n, n2);
        this.writeMatrix = new DoubleMatrix(n, n2);
    }

    public void setDiffusionConstant(double d) {
        this.diffCon = d;
    }

    public void setEvaporationRate(double d) {
        this.evapRate = d;
    }

    private void computeRow() {
        int n;
        this.prevX = n = this.xSize - 1;
        this.x = 0;
        while (this.x < n) {
            this.nextX = this.x + 1;
            this.computeVal();
            this.prevX = this.x;
            this.x = this.nextX;
        }
        this.nextX = 0;
        this.computeVal();
    }

    private void computeVal() {
        long l = (long)this.readMatrix.getDoubleAt(this.x, this.y);
        long l2 = 0L;
        l2 += (long)this.readMatrix.getDoubleAt(this.prevX, this.prevY);
        l2 += 4L * (long)this.readMatrix.getDoubleAt(this.x, this.prevY);
        l2 += (long)this.readMatrix.getDoubleAt(this.nextX, this.prevY);
        l2 += 4L * (long)this.readMatrix.getDoubleAt(this.prevX, this.y);
        l2 += 4L * (long)this.readMatrix.getDoubleAt(this.nextX, this.y);
        l2 += (long)this.readMatrix.getDoubleAt(this.prevX, this.nextY);
        l2 += 4L * (long)this.readMatrix.getDoubleAt(this.x, this.nextY);
        l2 += (long)this.readMatrix.getDoubleAt(this.nextX, this.nextY);
        double d = (double)(l2 -= 20L * l) / 20.0;
        double d2 = (double)l + d * this.diffCon;
        long l3 = (d2 *= this.evapRate) < -32767.0 ? -32767L : (d2 >= 32767.0 ? 32767L : (long)d2);
        this.writeMatrix.putDoubleAt(this.x, this.y, l3);
    }

    public void diffuse() {
        int n;
        this.prevY = n = this.ySize - 1;
        this.y = 0;
        while (this.y < n) {
            this.nextY = this.y + 1;
            this.computeRow();
            this.prevY = this.y;
            this.y = this.nextY;
        }
        this.nextY = 0;
        this.computeRow();
        this.writeMatrix.copyMatrixTo(this.readMatrix);
    }

    public void update() {
        this.writeMatrix.copyMatrixTo(this.readMatrix);
    }

    public double[] getVonNeumannNeighbors(int n, int n2) {
        return this.getVonNeumannNeighbors(n, n2, 1, 1);
    }

    public double[] getVonNeumannNeighbors(int n, int n2, int n3, int n4) {
        int n5;
        double[] dArray = new double[n3 * 2 + n4 * 2];
        int n6 = 0;
        int n7 = this.xnorm(n);
        int n8 = this.xnorm(n2);
        for (n5 = n - n3; n5 < n; ++n5) {
            dArray[n6++] = this.readMatrix.getDoubleAt(n5, n8);
        }
        for (n5 = n + n3; n5 > n; --n5) {
            dArray[n6++] = this.readMatrix.getDoubleAt(n5, n8);
        }
        for (n5 = n2 - n4; n5 < n2; ++n5) {
            dArray[n6++] = this.readMatrix.getDoubleAt(n7, n5);
        }
        for (n5 = n2 + n4; n5 > n2; --n5) {
            dArray[n6++] = this.readMatrix.getDoubleAt(n7, n5);
        }
        return dArray;
    }

    public double[] getMooreNeighbors(int n, int n2) {
        return this.getMooreNeighbors(n, n2, 1, 1);
    }

    public double[] getMooreNeighbors(int n, int n2, int n3, int n4) {
        double[] dArray = new double[n3 * n4 * 4 + n3 * 2 + n4 * 2];
        int n5 = 0;
        for (int i = n2 - n4; i <= n2 + n4; ++i) {
            for (int j = n - n3; j <= n + n3; ++j) {
                if (i == n2 && j == n) continue;
                dArray[n5++] = this.readMatrix.getDoubleAt(this.xnorm(j), this.ynorm(i));
            }
        }
        return dArray;
    }

    public double[] findMaximum(int n, int n2, int n3, boolean bl, int n4) {
        double[] dArray = n4 == 0 ? this.getVonNeumannNeighbors(n, n2, n3, n3) : this.getMooreNeighbors(n, n2, n3, n3);
        if (bl) {
            double[] dArray2 = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            dArray2[dArray2.length - 1] = this.getValueAt(n, n2);
            dArray = dArray2;
        }
        return this.compareMax(dArray);
    }

    protected double[] compareMax(double[] dArray) {
        if (dArray.length > 0) {
            Arrays.sort(dArray);
            int n = dArray.length - 1;
            double d = dArray[n];
            double d2 = dArray[n - 1];
            int n2 = 1;
            while (d == d2 && n2 < dArray.length) {
                d2 = n - ++n2;
            }
            double[] dArray2 = new double[n2];
            System.arraycopy(dArray, dArray.length - n2, dArray2, 0, n2);
            return dArray2;
        }
        return new double[0];
    }

    public double[] findMinimum(int n, int n2, int n3, boolean bl, int n4) {
        double[] dArray = n4 == 0 ? this.getVonNeumannNeighbors(n, n2, n3, n3) : this.getMooreNeighbors(n, n2, n3, n3);
        if (bl) {
            double[] dArray2 = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            dArray2[dArray2.length - 1] = this.getValueAt(n, n2);
            dArray = dArray2;
        }
        return this.compareMin(dArray);
    }

    protected double[] compareMin(double[] dArray) {
        if (dArray.length > 0) {
            Arrays.sort(dArray);
            double d = dArray[0];
            double d2 = dArray[1];
            int n = dArray.length - 1;
            int n2 = 1;
            while (d == d2 && ++n2 <= n) {
                d2 = dArray[n2];
            }
            double[] dArray2 = new double[n2];
            System.arraycopy(dArray, 0, dArray2, 0, n2);
            return dArray2;
        }
        return new double[0];
    }

    public int getSizeX() {
        return this.xSize;
    }

    public int getSizeY() {
        return this.ySize;
    }

    public Dimension getSize() {
        return new Dimension(this.xSize, this.ySize);
    }

    public Object getObjectAt(int n, int n2) {
        return new Long((long)this.readMatrix.getDoubleAt(this.xnorm(n), this.ynorm(n2)));
    }

    public double getValueAt(int n, int n2) {
        return this.readMatrix.getDoubleAt(this.xnorm(n), this.ynorm(n2));
    }

    public void putObjectAt(int n, int n2, Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("object must be a Number");
        }
        Number number = (Number)object;
        this.writeMatrix.putDoubleAt(this.xnorm(n), this.ynorm(n2), number.doubleValue());
    }

    public void putValueAt(int n, int n2, double d) {
        this.writeMatrix.putDoubleAt(this.xnorm(n), this.ynorm(n2), d);
    }

    public BaseMatrix getMatrix() {
        return this.readMatrix;
    }

    protected int xnorm(int n) {
        if (n > this.xSize - 1 || n < 0) {
            while (n < 0) {
                n += this.xSize;
            }
            return n % this.xSize;
        }
        return n;
    }

    protected int ynorm(int n) {
        if (n > this.ySize - 1 || n < 0) {
            while (n < 0) {
                n += this.ySize;
            }
            return n % this.ySize;
        }
        return n;
    }
}

