/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import cern.colt.list.FloatArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import uchicago.src.collection.RangeMap;
import uchicago.src.sim.network.ProbabilityRule;

public abstract class AbstractProbabilityRule
implements ProbabilityRule {
    protected FloatArrayList weights;
    protected Hashtable weightMap;
    protected double sum = 0.0;

    public AbstractProbabilityRule(List list, float f, Object object) {
        int n = list.size();
        this.weights = new FloatArrayList();
        this.weightMap = new Hashtable();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e == object) continue;
            this.weightMap.put(list.get(i), new Integer(n2++));
            this.weights.add(f);
        }
    }

    public AbstractProbabilityRule(List list, float f) {
        int n = list.size();
        this.weights = new FloatArrayList(n);
        this.weightMap = new Hashtable();
        for (int i = 0; i < n; ++i) {
            this.weightMap.put(list.get(i), new Integer(i));
            this.weights.add(f);
        }
    }

    public float addToNodeWeight(Object object, float f) {
        int n = (Integer)this.weightMap.get(object);
        float f2 = this.weights.getQuick(n) + f;
        this.weights.setQuick(n, f2);
        return f2;
    }

    public void addNode(Object object, float f) {
        this.weightMap.put(object, new Integer(this.weights.size()));
        this.weights.add(f);
    }

    protected float getWeight(Object object) {
        int n = (Integer)this.weightMap.get(object);
        return this.weights.getQuick(n);
    }

    public int getWeightListIndex(Object object) {
        return (Integer)this.weightMap.get(object);
    }

    public RangeMap makeProbabilityMap(RangeMap rangeMap) {
        this.calcSum();
        rangeMap.clear();
        Enumeration enumeration = this.weightMap.keys();
        float f = 0.0f;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            float f2 = (float)this.getProbability(k);
            if (f2 + f == f) continue;
            try {
                rangeMap.put(f, k);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("lowerBound: " + f);
                System.out.println("prob: " + f2);
            }
            f += f2;
        }
        return rangeMap;
    }

    protected void calcSum() {
        int n = this.weights.size();
        this.sum = 0.0;
        for (int i = 0; i < n; ++i) {
            this.sum += (double)this.weights.getQuick(i);
        }
    }

    public abstract double getProbability(Object var1);

    public abstract void update(Object var1);

    public abstract void update(Object var1, float var2);
}

