/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.guiUtils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import uchicago.src.guiUtils.GuiUtilities;

public abstract class Wizard
extends JPanel {
    protected JButton btnNext = new JButton("Next");
    protected JButton btnBack = new JButton("Back");
    protected JButton btnCancel = new JButton("Cancel");
    protected JPanel top;
    protected JDialog dialog;
    protected Dimension mySize = null;
    protected boolean exitOnClose = false;
    protected boolean cancel = false;
    protected Stack panels = new Stack();

    public Wizard() {
        this(false);
    }

    public Wizard(boolean bl) {
        this.exitOnClose = bl;
        this.guiInit();
        this.setCommands();
    }

    private void setCommands() {
        this.btnNext.setActionCommand("next");
        this.btnBack.setActionCommand("back");
        this.btnCancel.setActionCommand("cancel");
    }

    protected void guiInit() {
        this.setLayout(new BorderLayout());
        if (this.top != null) {
            this.add((Component)this.top, "Center");
        }
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.btnBack);
        jPanel2.add(this.btnNext);
        jPanel3.add(this.btnCancel);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.add((Component)jPanel, "South");
        this.btnNext.setMnemonic('n');
        this.btnBack.setMnemonic('b');
        this.btnCancel.setMnemonic('c');
    }

    public void setTopPanel(JPanel jPanel) {
        if (this.top != null) {
            this.remove(this.top);
            this.top = null;
        }
        this.top = jPanel;
        this.add((Component)this.top, "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void display(JFrame jFrame, String string, boolean bl) {
        if (jFrame == null) {
            jFrame = new JFrame();
        }
        this.dialog = new JDialog((Frame)jFrame, true);
        this.dialog.setTitle(string);
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Wizard.this.cancel = true;
                Wizard.this.close();
            }
        });
        if (this.mySize == null) {
            this.dialog.pack();
        } else {
            this.dialog.setSize(this.mySize);
        }
        if (bl) {
            this.dialog.setLocationRelativeTo(jFrame);
        } else {
            GuiUtilities.centerComponentOnScreen(this.dialog);
        }
        this.dialog.setVisible(true);
    }

    public void display(JDialog jDialog, String string, boolean bl) {
        if (jDialog == null) {
            jDialog = new JDialog();
        }
        this.dialog = new JDialog((Dialog)jDialog, true);
        this.dialog.setTitle(string);
        Container container = this.dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Wizard.this.cancel = true;
                Wizard.this.close();
            }
        });
        if (this.mySize == null) {
            this.dialog.pack();
        } else {
            this.dialog.setSize(this.mySize);
        }
        if (bl) {
            this.dialog.setLocationRelativeTo(jDialog);
        } else {
            GuiUtilities.centerComponentOnScreen(this.dialog);
        }
        this.dialog.setVisible(true);
    }

    public void setSize(int n, int n2) {
        this.mySize = new Dimension(n, n2);
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
        if (this.exitOnClose) {
            System.exit(0);
        }
    }

    public void setNextEnabled(boolean bl) {
        this.btnNext.setEnabled(bl);
    }

    public void setBackEnabled(boolean bl) {
        this.btnBack.setEnabled(bl);
    }

    public void setNextToFinish() {
        this.btnNext.setText("Finished");
    }
}

