/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloBoolDomain;
import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDomain;
import ilog.concert.IloException;
import ilog.concert.IloIntDomain;
import ilog.concert.IloIntEnumeratedVar;
import ilog.concert.IloIntVar;
import ilog.concert.IloNumVarType;
import ilog.concert.IloStorable;
import ilog.concert.model.IlcIntDomain;
import ilog.solver.IlcGoal;
import ilog.solver.IlcInstantiable;
import ilog.solver.IlcIntCollectionVarInterface;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverError;
import ilog.solver.os;

public final class IlcIntVar
extends IlcIntExpr
implements IloIntEnumeratedVar,
IlcInstantiable,
IlcIntCollectionVarInterface,
IloStorable {
    protected String _name = null;
    protected IloIntDomain _domain = null;
    int pwb = -1;

    private void wv() throws IloException {
        if (this._extracted.getSolver().getSearch() != null) {
            throw new IlcSolverError.CannotModifyModel();
        }
    }

    public IloNumVarType getType() throws IloException {
        return IloNumVarType.Int;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public IlcIntVar(IloIntDomain iloIntDomain, String string) {
        this._name = string;
        this._domain = iloIntDomain;
    }

    public IlcIntVar(IloIntDomain iloIntDomain) {
        this(iloIntDomain, null);
    }

    public IlcIntVar(int n2, int n3, String string) throws IloException {
        this._name = string;
        this._domain = new IlcIntDomain(n2, n3);
    }

    public IlcIntVar(int n2, int n3) throws IloException {
        this(n2, n3, null);
    }

    public IlcIntVar(int[] nArray, String string) throws IloException {
        this._name = string;
        this._domain = new IlcIntDomain(nArray);
    }

    public IlcIntVar(int[] nArray) throws IloException {
        this(nArray, null);
    }

    public int getMin() {
        return this._domain.getMin();
    }

    public double getLB() {
        return this._domain.getMin();
    }

    public int getMax() {
        return this._domain.getMax();
    }

    public double getUB() {
        return this._domain.getMax();
    }

    public void setMin(int n2) throws IloException {
        this.wv();
        this._domain.setMin(n2);
    }

    public void setLB(double d2) throws IloException {
        this.wv();
        this._domain.setMin((int)Math.ceil(d2));
    }

    public void setMax(int n2) throws IloException {
        this.wv();
        this._domain.setMax(n2);
    }

    public void setUB(double d2) throws IloException {
        this.wv();
        this._domain.setMax((int)Math.floor(d2));
    }

    public void setValues(int[] nArray) throws IloException {
        this.wv();
        this._domain.setValues(nArray);
    }

    public int[] getValues() {
        return this._domain.getValues();
    }

    public void setValue(int n2) throws IloException {
        this.wv();
        this._domain.setValue(n2);
    }

    public void setRange(int n2, int n3) throws IloException {
        this.wv();
        this._domain.setRange(n2, n3);
    }

    public void removeValue(int n2) throws IloException {
        this.wv();
        this._domain.removeValue(n2);
    }

    public void removeInterval(int n2, int n3) throws IloException {
        this.wv();
        this._domain.removeInterval(n2, n3);
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        ilcSolver.addVar(this);
        if (this._domain.getValues() == null) {
            int n2 = this._domain.getMin();
            int n3 = this._domain.getMax();
            return IlcPIntAbstractVar.intVar(ilcSolver, n2, n3, this.getName());
        }
        return IlcPIntAbstractVar.intVar(ilcSolver, this._domain.getValues(), this.getName());
    }

    public synchronized String toString() {
        if (!(this._extracted instanceof os)) {
            return this._extracted.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._name != null) {
            stringBuffer.append(this._name);
        }
        stringBuffer.append(this._domain);
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        if (this._domain.getValues() == null) {
            IloDomain iloDomain = (IloDomain)iloCopyManager.getCopy(this._domain);
            if (this._domain instanceof IloBoolDomain) {
                IloIntVar iloIntVar = iloCPModeler.boolVar((IloBoolDomain)iloDomain);
                if (this._name != null) {
                    iloIntVar.setName(this._name);
                }
                return iloIntVar;
            }
            return iloCPModeler.intVar((IloIntDomain)iloDomain, this._name);
        }
        return iloCPModeler.intVar(this._domain.getValues(), this._name);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        if (check instanceof IloCopyManager.ExistGroundTerm) {
            throw check;
        }
        this._domain.needCopy(check);
    }

    public IlcGoal initDefaultGoal(IlcSolver ilcSolver) {
        return ilcSolver.generate(this);
    }
}

