/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import layout.TableLayout;
import uchicago.src.guiUtils.GuiUtilities;
import uchicago.src.sim.analysis.AbstractChartModel;
import uchicago.src.sim.analysis.AddChartGui;
import uchicago.src.sim.analysis.EditChartGui;
import uchicago.src.sim.engine.SimModel;

public class CustomChartGui
extends JPanel {
    JButton btnAdd = new JButton("Add");
    JButton btnEdit = new JButton("Edit");
    JButton btnDelete = new JButton("Delete");
    JButton btnOK = new JButton("OK");
    JButton btnCancel = new JButton("Cancel");
    JDialog dialog;
    SimModel simModel;
    JList chartList = new JList();
    private ArrayList modelList = new ArrayList();

    public CustomChartGui(SimModel simModel, ArrayList arrayList) {
        super(new BorderLayout(), true);
        this.simModel = simModel;
        int n = 10;
        this.chartList.setModel(new DefaultListModel());
        double[][] dArrayArray = new double[][]{{n, 0.75, n, 0.25, n}, {n, n, 0.2, n, 0.2, n, 0.2, n, 0.2, 0.2}};
        JPanel jPanel = new JPanel(new TableLayout(dArrayArray));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Charts"));
        jPanel2.add((Component)new JScrollPane(this.chartList), "Center");
        jPanel.add((Component)jPanel2, "1, 1, 0, 9");
        jPanel.add((Component)this.btnAdd, "3, 2");
        jPanel.add((Component)this.btnEdit, "3, 4");
        jPanel.add((Component)this.btnDelete, "3, 6");
        this.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.btnOK);
        jPanel3.add(this.btnCancel);
        this.add((Component)jPanel3, "South");
        this.addListeners();
        DefaultListModel defaultListModel = (DefaultListModel)this.chartList.getModel();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            defaultListModel.addElement(arrayList.get(i));
        }
    }

    private void addListeners() {
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomChartGui.this.dialog.dispose();
                CustomChartGui.this.modelList.clear();
                DefaultListModel defaultListModel = (DefaultListModel)CustomChartGui.this.chartList.getModel();
                for (int i = 0; i < defaultListModel.size(); ++i) {
                    CustomChartGui.this.modelList.add(defaultListModel.get(i));
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomChartGui.this.modelList = null;
                CustomChartGui.this.dialog.dispose();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddChartGui addChartGui = new AddChartGui(CustomChartGui.this.simModel);
                addChartGui.display(CustomChartGui.this.dialog, "Add Chart", true);
                if (addChartGui.getModel() != null) {
                    DefaultListModel defaultListModel = (DefaultListModel)CustomChartGui.this.chartList.getModel();
                    defaultListModel.addElement(addChartGui.getModel());
                }
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomChartGui.this.chartList.getSelectedIndex();
                if (n != -1) {
                    DefaultListModel defaultListModel = (DefaultListModel)CustomChartGui.this.chartList.getModel();
                    defaultListModel.remove(n);
                }
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomChartGui.this.chartList.getSelectedIndex();
                if (n != -1) {
                    AbstractChartModel abstractChartModel = (AbstractChartModel)CustomChartGui.this.chartList.getSelectedValue();
                    EditChartGui editChartGui = new EditChartGui(abstractChartModel.copy());
                    editChartGui.display(CustomChartGui.this.dialog);
                    abstractChartModel = editChartGui.getModel();
                    if (abstractChartModel != null) {
                        DefaultListModel defaultListModel = (DefaultListModel)CustomChartGui.this.chartList.getModel();
                        defaultListModel.remove(n);
                        if (n >= defaultListModel.size()) {
                            defaultListModel.addElement(abstractChartModel);
                        } else {
                            defaultListModel.insertElementAt(abstractChartModel, n);
                        }
                    }
                }
            }
        });
        this.chartList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                AbstractChartModel abstractChartModel = (AbstractChartModel)object;
                jLabel.setIcon(abstractChartModel.getIcon());
                jLabel.setText(abstractChartModel.getTitle());
                return jLabel;
            }
        });
    }

    public void display(JFrame jFrame) {
        this.dialog = new JDialog(jFrame, "Dynamic Charts", true);
        this.dialog.setSize(336, 238);
        this.dialog.setContentPane(this);
        GuiUtilities.centerComponentOnScreen(this.dialog);
        this.dialog.setVisible(true);
    }

    public ArrayList getModels() {
        return this.modelList;
    }
}

