/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uchicago.src.sim.analysis.AbstractChartModel;
import uchicago.src.sim.analysis.SequenceChartModel;
import uchicago.src.sim.analysis.SequenceSource;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.util.SimUtilities;

public class ChartArchiver {
    public static ArrayList loadCharts(SimModel simModel) {
        String string = simModel.getClass().getName();
        String string2 = System.getProperty("user.home");
        String string3 = string2 + File.separator + ".repast" + File.separator + string.replace('.', File.separatorChar);
        String string4 = string3 + File.separator + "charts.xml";
        File file = new File(string4);
        if (file.exists()) {
            return ChartArchiver.loadXML(string4, simModel);
        }
        return new ArrayList();
    }

    private static ArrayList loadXML(String string, SimModel simModel) {
        ArrayList<SequenceChartModel> arrayList = new ArrayList<SequenceChartModel>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new FileInputStream(string), string);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("ChartModel");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("type");
                if (!string2.equals("SequenceChart")) continue;
                arrayList.add(ChartArchiver.loadSequenceChart(element2, simModel));
            }
        }
        catch (Exception exception) {
            SimUtilities.showError("Error loading persistent chart sizes and positions", exception);
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static SequenceChartModel loadSequenceChart(Element element, SimModel simModel) {
        SequenceChartModel sequenceChartModel = new SequenceChartModel(simModel);
        sequenceChartModel.setTitle(element.getAttribute("title"));
        sequenceChartModel.setXAxisTitle(element.getAttribute("xAxisTitle"));
        sequenceChartModel.setYAxisTitle(element.getAttribute("yAxisTitle"));
        sequenceChartModel.setXRangeMin(element.getAttribute("xRangeMin"));
        sequenceChartModel.setXRangeMax(element.getAttribute("xRangeMax"));
        sequenceChartModel.setXRangeIncr(element.getAttribute("xRangeIncr"));
        sequenceChartModel.setYRangeMin(element.getAttribute("yRangeMin"));
        sequenceChartModel.setYRangeMax(element.getAttribute("yRangeMax"));
        sequenceChartModel.setYRangeIncr(element.getAttribute("yRangeIncr"));
        NodeList nodeList = element.getElementsByTagName("DataSource");
        ArrayList<SequenceSource> arrayList = new ArrayList<SequenceSource>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            SequenceSource sequenceSource = new SequenceSource(simModel);
            sequenceSource.setName(element2.getAttribute("name"));
            sequenceSource.setColor(new Color(Integer.parseInt(element2.getAttribute("color"))));
            sequenceSource.setMethodName(element2.getAttribute("methodName"));
            sequenceSource.setMarkStyle(Integer.parseInt(element2.getAttribute("markStyle")));
            arrayList.add(sequenceSource);
        }
        sequenceChartModel.setDataSources(arrayList);
        return sequenceChartModel;
    }

    public static void saveCharts(String string, ArrayList arrayList) {
        String string2 = System.getProperty("user.home");
        String string3 = string2 + File.separator + ".repast" + File.separator + string.replace('.', File.separatorChar);
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        String string4 = string3 + File.separator + "charts.xml";
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string4));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<!-- RePast Custom Chart Description File -->");
            bufferedWriter.newLine();
            bufferedWriter.write("<RePast:Charts xmlns:RePast=\"http://src.uchicago.edu/repast/\" >");
            bufferedWriter.newLine();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                AbstractChartModel abstractChartModel = (AbstractChartModel)arrayList.get(i);
                bufferedWriter.write(abstractChartModel.toXML());
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</RePast:Charts>");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error storing persistent chart sizes and positions", iOException);
            iOException.printStackTrace();
        }
    }
}

