/*
 * Decompiled with CFR 0.152.
 */
package anl.repast.gis.display;

import anl.repast.gis.MultiLayerOpenMapAgent;
import anl.repast.gis.data.OpenMapData;
import anl.repast.gis.display.MultiCancelMoveAction;
import anl.repast.gis.display.MultiMoveAction;
import anl.repast.gis.display.MultiPropertiesAction;
import anl.repast.gis.display.MultiUndoMoveAction;
import anl.repast.gis.display.OpenMapDisplay;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriPolygon;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.omGraphics.OMArc;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class RepastOMMultiLayer
extends OMGraphicHandlerLayer
implements DataBoundsProvider {
    List agentList;
    OMGraphicList currentList;
    Paint highlightFillPaint;
    Paint originalFillPaint;
    boolean waitingToMove;
    LatLonPoint moveFromPoint;
    MultiLayerOpenMapAgent agentToMove;
    OpenMapDisplay omDisplay;
    Point moveToPoint;
    MultiLayerOpenMapAgent movedAgent;
    OMGraphic movedOMG;
    String title;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public RepastOMMultiLayer(OpenMapDisplay openMapDisplay, String string) {
        this.omDisplay = openMapDisplay;
        this.title = string;
    }

    public void setAgentList(List list) {
        this.agentList = list;
    }

    public MultiLayerOpenMapAgent getAgentFromOMGraphic(OMGraphic oMGraphic) {
        int n = this.currentList.indexOf(oMGraphic);
        return (MultiLayerOpenMapAgent)this.agentList.get(n);
    }

    public MultiLayerOpenMapAgent findClosestAgent(int n, int n2) {
        OMGraphic oMGraphic = this.currentList.findClosest(n, n2);
        return this.getAgentFromOMGraphic(oMGraphic);
    }

    public MultiLayerOpenMapAgent findClosestAgent(Point point) {
        OMGraphic oMGraphic = this.currentList.findClosest(point.x, point.y);
        return this.getAgentFromOMGraphic(oMGraphic);
    }

    public MultiLayerOpenMapAgent findClosestAgent(Point point, float f) {
        OMGraphic oMGraphic = this.currentList.findClosest(point.x, point.y, f);
        return this.getAgentFromOMGraphic(oMGraphic);
    }

    public MultiLayerOpenMapAgent findClosestAgent(int n, int n2, float f) {
        OMGraphic oMGraphic = this.currentList.findClosest(n, n2, f);
        return this.getAgentFromOMGraphic(oMGraphic);
    }

    public synchronized OMGraphicList prepare() {
        Projection projection;
        OMGraphicList oMGraphicList = new OMGraphicList();
        List list = this.getAgentList();
        if (list != null) {
            projection = list.iterator();
            while (projection.hasNext()) {
                MultiLayerOpenMapAgent multiLayerOpenMapAgent = (MultiLayerOpenMapAgent)projection.next();
                OMGraphic oMGraphic = multiLayerOpenMapAgent.getOMGraphic();
                oMGraphic.setFillPaint(multiLayerOpenMapAgent.getFillPaint(this.title));
                oMGraphicList.add(oMGraphic);
            }
        }
        this.setList(oMGraphicList);
        projection = this.getProjection();
        this.currentList = this.getList();
        if (this.currentList != null && projection != null) {
            this.currentList.generate(projection);
        }
        return this.currentList;
    }

    public void select(OMGraphicList oMGraphicList) {
        if (oMGraphicList != null) {
            Iterator iterator = oMGraphicList.iterator();
            while (iterator.hasNext()) {
                OMGraphic oMGraphic;
                if (this.selectedList == null) {
                    this.selectedList = new OMGraphicList();
                }
                if ((oMGraphic = (OMGraphic)iterator.next()) instanceof OMGraphicList && !((OMGraphicList)oMGraphic).isVague()) {
                    this.select((OMGraphicList)oMGraphic);
                    continue;
                }
                this.selectedList.add(oMGraphic);
            }
        }
    }

    public void deselect(OMGraphicList oMGraphicList) {
        if (oMGraphicList != null) {
            Iterator iterator = oMGraphicList.iterator();
            while (iterator.hasNext() && this.selectedList != null) {
                OMGraphic oMGraphic = (OMGraphic)iterator.next();
                if (oMGraphic instanceof OMGraphicList && !((OMGraphicList)oMGraphic).isVague()) {
                    this.deselect((OMGraphicList)oMGraphic);
                    continue;
                }
                this.selectedList.remove(oMGraphic);
            }
        }
    }

    public void highlight(OMGraphic oMGraphic) {
        MultiLayerOpenMapAgent multiLayerOpenMapAgent = this.getAgentFromOMGraphic(oMGraphic);
        this.originalFillPaint = multiLayerOpenMapAgent.getFillPaint(this.title);
        oMGraphic.setFillPaint(this.highlightFillPaint);
        oMGraphic.select();
        oMGraphic.generate(this.getProjection());
        this.repaint();
    }

    public void unhighlight(OMGraphic oMGraphic) {
        oMGraphic.setFillPaint(this.originalFillPaint);
        oMGraphic.deselect();
        oMGraphic.generate(this.getProjection());
        this.repaint();
    }

    public boolean isSelectable(OMGraphic oMGraphic) {
        return true;
    }

    public String getToolTipTextFor(OMGraphic oMGraphic) {
        MultiLayerOpenMapAgent multiLayerOpenMapAgent = (MultiLayerOpenMapAgent)this.agentList.get(this.currentList.indexOf(oMGraphic));
        String[] stringArray = multiLayerOpenMapAgent.gisPropertyList();
        Class<?> clazz = multiLayerOpenMapAgent.getClass();
        StringBuffer stringBuffer = new StringBuffer("<HTML><BODY>");
        if (stringArray != null && stringArray.length > 0) {
            try {
                for (int i = 0; i < stringArray.length; i += 2) {
                    Method method = clazz.getMethod(stringArray[i + 1], null);
                    stringBuffer.append("<b>" + stringArray[i] + "</b>&nbsp;&nbsp;" + method.invoke((Object)multiLayerOpenMapAgent, null) + "<BR>");
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            stringBuffer.append("</BODY></HTML>");
        }
        return stringBuffer.toString();
    }

    public String getInfoText(OMGraphic oMGraphic) {
        MultiLayerOpenMapAgent multiLayerOpenMapAgent = (MultiLayerOpenMapAgent)this.agentList.get(this.currentList.indexOf(oMGraphic));
        Class<?> clazz = multiLayerOpenMapAgent.getClass();
        try {
            Method method = clazz.getMethod("getGisAgentIndex", null);
            return "" + method.invoke((Object)multiLayerOpenMapAgent, null);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return "";
    }

    public List getItemsForOMGraphicMenu(OMGraphic oMGraphic) {
        AbstractAction abstractAction;
        JMenuItem jMenuItem;
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        JMenuItem jMenuItem2 = new JMenuItem("Properties");
        MultiPropertiesAction multiPropertiesAction = new MultiPropertiesAction("Properties", oMGraphic, this.currentList, this.getAgentList());
        jMenuItem2.setAction(multiPropertiesAction);
        arrayList.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem();
        arrayList.add(jMenuItem3);
        if (!(oMGraphic instanceof OMPoly)) {
            jMenuItem = new JMenuItem("Move Agent");
            abstractAction = new MultiMoveAction("Move Agent", oMGraphic, this);
            jMenuItem.setAction(abstractAction);
            arrayList.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Cancel Move Agent");
        abstractAction = new MultiCancelMoveAction("Cancel Move Agent", this);
        jMenuItem.setAction(abstractAction);
        arrayList.add(jMenuItem);
        JMenuItem jMenuItem4 = new JMenuItem("Undo Move Agent");
        MultiUndoMoveAction multiUndoMoveAction = new MultiUndoMoveAction("Undo Move Agent", this);
        jMenuItem4.setAction(multiUndoMoveAction);
        arrayList.add(jMenuItem4);
        return arrayList;
    }

    public List getItemsForMapMenu(MapMouseEvent mapMouseEvent) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        JMenuItem jMenuItem = new JMenuItem("Cancel Move Agent");
        MultiCancelMoveAction multiCancelMoveAction = new MultiCancelMoveAction("Cancel Move Agent", this);
        jMenuItem.setAction(multiCancelMoveAction);
        arrayList.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Undo Move Agent");
        MultiUndoMoveAction multiUndoMoveAction = new MultiUndoMoveAction("Undo Move Agent", this);
        jMenuItem2.setAction(multiUndoMoveAction);
        arrayList.add(jMenuItem2);
        return arrayList;
    }

    public boolean receivesMapEvents() {
        return true;
    }

    public LatLonPoint getCenter(float[] fArray) {
        LatLonPoint latLonPoint = new LatLonPoint();
        latLonPoint.setLatitude((fArray[0] + fArray[2]) / 2.0f);
        latLonPoint.setLongitude((fArray[1] + fArray[3]) / 2.0f);
        return latLonPoint;
    }

    public float[] getExtents(OMGraphic oMGraphic) {
        if (oMGraphic instanceof EsriGraphic) {
            return ((EsriGraphic)oMGraphic).getExtents();
        }
        if (oMGraphic instanceof OMPoint) {
            float[] fArray = new float[]{((OMPoint)oMGraphic).getLat(), ((OMPoint)oMGraphic).getLon()};
            return fArray;
        }
        if (oMGraphic instanceof OMPoly) {
            EsriPolygon esriPolygon = EsriPolygon.convert((OMPoly)((OMPoly)oMGraphic));
            return esriPolygon.getExtents();
        }
        return null;
    }

    public void setWaitingToMove(boolean bl) {
        this.waitingToMove = bl;
    }

    public void setAgentToMove(MultiLayerOpenMapAgent multiLayerOpenMapAgent) {
        this.agentToMove = multiLayerOpenMapAgent;
    }

    public MultiLayerOpenMapAgent getAgentToMove() {
        return this.agentToMove;
    }

    public void setMoveFromPoint(LatLonPoint latLonPoint) {
        this.moveFromPoint = latLonPoint;
    }

    public LatLonPoint getMoveFromPoint(OMGraphic oMGraphic) {
        LatLonPoint latLonPoint = null;
        latLonPoint = oMGraphic instanceof OMArc ? ((OMArc)oMGraphic).getCenter() : (oMGraphic instanceof Location ? new LatLonPoint(((Location)oMGraphic).lat, ((Location)oMGraphic).lon) : this.getCenter(this.getExtents(oMGraphic)));
        return latLonPoint;
    }

    public static void main(String[] stringArray) {
    }

    public void undoMoveAgent() {
        Class<?> clazz = this.movedAgent.getClass();
        try {
            Method method = clazz.getMethod("getOMGraphic", null);
            method.invoke((Object)this.movedAgent, null);
            this.moveAgent(this.moveFromPoint);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void moveAgent(LatLonPoint latLonPoint) {
        this.moveAgent(this.omDisplay.latLonToPoint(latLonPoint));
    }

    public void moveAgent(Point point) {
        this.moveAgent(point.x, point.y);
    }

    public void moveAgent(int n, int n2) {
        MultiLayerOpenMapAgent multiLayerOpenMapAgent;
        this.movedAgent = multiLayerOpenMapAgent = this.getAgentToMove();
        this.movedOMG = null;
        Class<?> clazz = multiLayerOpenMapAgent.getClass();
        try {
            OMGraphic oMGraphic;
            Method method = clazz.getMethod("getOMGraphic", null);
            this.movedOMG = oMGraphic = (OMGraphic)method.invoke((Object)multiLayerOpenMapAgent, null);
            if (oMGraphic instanceof OMPoint) {
                LatLonPoint latLonPoint = this.omDisplay.xyToLatLon(n, n2);
                ((OMPoint)oMGraphic).setLat(latLonPoint.getLatitude());
                ((OMPoint)oMGraphic).setLon(latLonPoint.getLongitude());
                Object[] objectArray = new Object[]{oMGraphic};
                Class[] classArray = new Class[]{OMGraphic.class};
                method = clazz.getMethod("setOMGraphic", classArray);
                method.invoke((Object)multiLayerOpenMapAgent, objectArray);
                this.doPrepare();
            } else {
                if (oMGraphic instanceof OMPoly) {
                    return;
                }
                if (oMGraphic instanceof OMArc) {
                    LatLonPoint latLonPoint = this.omDisplay.xyToLatLon(n, n2);
                    ((OMArc)oMGraphic).setLatLon(latLonPoint.getLatitude(), latLonPoint.getLongitude());
                    Object[] objectArray = new Object[]{oMGraphic};
                    Class[] classArray = new Class[]{OMGraphic.class};
                    method = clazz.getMethod("setOMGraphic", classArray);
                    method.invoke((Object)multiLayerOpenMapAgent, objectArray);
                    this.doPrepare();
                } else if (oMGraphic instanceof Location) {
                    LatLonPoint latLonPoint = this.omDisplay.xyToLatLon(n, n2);
                    ((Location)oMGraphic).setLocation(latLonPoint.getLatitude(), latLonPoint.getLongitude());
                    Object[] objectArray = new Object[]{oMGraphic};
                    Class[] classArray = new Class[]{OMGraphic.class};
                    method = clazz.getMethod("setOMGraphic", classArray);
                    method.invoke((Object)multiLayerOpenMapAgent, objectArray);
                    this.doPrepare();
                }
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void setMoveToPoint(Point point) {
        this.moveToPoint = point;
    }

    public boolean leftClick(MapMouseEvent mapMouseEvent) {
        if (this.waitingToMove) {
            this.waitingToMove = false;
            this.setMoveToPoint(new Point(mapMouseEvent.getX(), mapMouseEvent.getY()));
            this.moveAgent(mapMouseEvent.getX(), mapMouseEvent.getY());
        }
        return true;
    }

    public boolean mouseOver(MapMouseEvent mapMouseEvent) {
        return true;
    }

    public Paint getHighlightFillPaint() {
        return this.highlightFillPaint;
    }

    public void setHighlightFillPaint(Paint paint) {
        this.highlightFillPaint = paint;
    }

    public List getAgentList() {
        return this.agentList;
    }

    public void ActionPerformed(ActionEvent actionEvent) {
    }

    public DataBounds getDataBounds() {
        OpenMapData openMapData = OpenMapData.getInstance();
        float[] fArray = openMapData.getExtents(openMapData.buildEsriGraphicList(this.getAgentList()));
        DataBounds dataBounds = new DataBounds((double)fArray[1], (double)fArray[0], (double)fArray[3], (double)fArray[2]);
        return dataBounds;
    }

    public String getName() {
        return this.title;
    }
}

