import codebreaking.GuessResult.FoundSolution
import codebreaking.*
import codebreaking.MasterMind.Color.*

/// # Scores

// Grey, Green, Yellow, Grey, Grey
Wordle.score("dries", "fruit")

// Score(3, 1)
BullsAndCows.score(
  List(5, 2, 7, 2, 3, 3),
  List(5, 2, 7, 3, 4, 6)
)

// Score(2, 2)
MasterMind.score(
  List(Carmine, Purple, Fuchsia, Pink, Purple),
  List(Carmine, Pink, Pink, Purple, Purple),
)

/// # Solving

// StillGuessing
BullsAndCows.Game(3).guess(
  List(
    ScoredGuess(List(1, 2, 3), BullsAndCows.Score(1, 1)),
    ScoredGuess(List(7, 2, 5), BullsAndCows.Score(2, 0)),
  )
)

// FoundSolution(List(3, 2, 5))
BullsAndCows.Game(3).guess(
  List(
    ScoredGuess(List(1, 2, 3), BullsAndCows.Score(1, 1)),
    ScoredGuess(List(7, 2, 5), BullsAndCows.Score(2, 0)),
    ScoredGuess(List(7, 2, 1), BullsAndCows.Score(1, 0))
  )
)

// FoundSolution(List(3, 2, 5))
BullsAndCows.Game(3).guess(
  List(
    ScoredGuess(List(1, 2, 3), BullsAndCows.Score(1, 1)),
    ScoredGuess(List(7, 2, 5), BullsAndCows.Score(2, 0)),
    ScoredGuess(List(1, 3, 7), BullsAndCows.Score(0, 1))
  )
)

// StillGuessing
BullsAndCows.Game(3).guess(
  List(
    ScoredGuess(List(1, 2, 3), BullsAndCows.Score(1, 1)),
    ScoredGuess(List(7, 2, 5), BullsAndCows.Score(2, 0)),
    ScoredGuess(List(0, 0, 8), BullsAndCows.Score(0, 0))
  )
)

// Some(List(8))
BullsAndCows.solve(10, List(8))

/// # Other tests

MasterMind.solve(100, List(Blue, Blue))
MasterMind.solve(16, List(Blue, Green, Pink))
MasterMind.solve(8, List(Fuchsia, Fuchsia, Blue, Red))
MasterMind.solve(8, List(Blue, Carmine, Purple, Fuchsia, Green))
