package scalashop.image

import scalashop.common.*

object GameOfLife:

  enum State:
    case Alive, Dead

    /** Gets the corresponding color for this state */
    def toColor: Pixel = this match
      case Alive => State.aliveColor
      case Dead  => State.deadColor

    /** Computes the next state based on the given state of its neighbours */
    def step(neighbours: Seq[State]): State =
      ???

  object State:
    val aliveColor = argb(255, 0, 0, 0) // black
    val deadColor = argb(255, 255, 255, 255) // white

    /** Gets the corresponding state for the given color. */
    def fromColor(color: Pixel): State =
      if color == aliveColor then Alive
      else Dead

  /** Given a source image, assumed to be a Game of Life grid, computes the next
    * state of the grid as a filter.
    *
    * @param src
    *   the source grid
    */
  class Step(src: Image) extends Image(src.height, src.width):
    /** Gets the source pixel at the given coordinates, but wraps around the
      * edges
      */
    def wrappedSource(x: Int, y: Int): Pixel =
      src(math.floorMod(x, width), math.floorMod(y, height))

    /** Gets the neighbours of the given pixel, looping around the edges */
    def neighbours(x: Int, y: Int): Seq[Pixel] =
      for
        kX <- x - 1 to x + 1
        kY <- y - 1 to y + 1
        if kX != x || kY != y
      yield wrappedSource(kX, kY)

    /** Gets the next state for the given pixel */
    def apply(x: Int, y: Int): Pixel =
      ???
