package codebreaking

import GuessResult.*

class WordleSolveSuite extends TimedSuite(7):
  import Wordle.*
  import Wordle.Result.*

  test("Wordle: Base case (1pt)"):
    assertEquals(
      Wordle.Game(1, Set("a")).guess(List()),
      FoundSolution("a")
    )

  def simpleGame =
    Wordle.Game(3, Set("abc", "abd", "acf", "adf", "xyz", "yzx", "zxy", "abcdef"))

  test("Wordle: Single solution: single guess (1pt)"):
    assertEquals(
      simpleGame.guess(
        List(ScoredGuess("adf", List(Green, Yellow, Grey)))
      ),
      FoundSolution("abd")
    )

  test("Wordle: Single solution: two guesses, redundant (1pt)"):
    assertEquals(
      simpleGame.guess(
        List(
          ScoredGuess("adf", List(Green, Yellow, Grey)),
          ScoredGuess("adf", List(Green, Yellow, Grey))
        )
      ),
      FoundSolution("abd")
    )

  test("Wordle: Single solution: two guesses, required (1pt)"):
    assertEquals(
      simpleGame.guess(
        List(
          ScoredGuess("xyz", List(Grey, Grey, Grey)),
          ScoredGuess("adf", List(Green, Yellow, Grey))
        )
      ),
      FoundSolution("abd")
    )

  test("Wordle: Single solution: correct (1pt)"):
    assertEquals(
      simpleGame.guess(
        List(ScoredGuess("xyz", List(Green, Green, Green)))
      ),
      FoundSolution("xyz")
    )

  test("Wordle: Multiple solutions (1pt)"):
    simpleGame.guess(
      List(ScoredGuess("xyz", List(Yellow, Yellow, Yellow)))
    ) match
      case StillGuessing(_) => {}
      case r                => throw AssertionError(f"Unexpected response: $r")

  test("Wordle: No solution (1pt)"):
    assertEquals(
      simpleGame.guess(
        List(
          ScoredGuess("xyz", List(Green, Green, Grey)),
          ScoredGuess("adf", List(Green, Grey, Green))
        )
      ),
      NoSolution
    )

  test("Wordle.solve(4, WordLists.enNGSL, \"album\") (1pt)"):
    assertEquals(
      Wordle.solve(4, WordLists.enNGSL, "album"),
      Some("album")
    )

  test("Wordle.solve(4, WordLists.enNGSL, \"world\") (1pt)"):
    assertEquals(
      Wordle.solve(4, WordLists.enNGSL, "world"),
      Some("world")
    )

  test("Wordle.solve(6, WordLists.enDebian, \"forecasting\") (1pt)"):
    assertEquals(
      Wordle.solve(6, WordLists.enDebian, "forecasting"),
      Some("forecasting")
    )

  test("Wordle.solve(8, WordLists.enWordle, \"flame\") (1pt)"):
    assertEquals(
      Wordle.solve(8, WordLists.enWordle, "flame"),
      Some("flame")
    )

  test("Wordle.solve(8, WordLists.enWordle, \"being\") (1pt)"):
    assertEquals(
      Wordle.solve(8, WordLists.enWordle, "being"),
      Some("being")
    )
