package codebreaking

class WordleScoreSuite extends TimedSuite(1):
  import Wordle.*
  import Wordle.Result.*
  import WordLists.*

  test("Wordle.score(\"\", \"\") (2pts)"):
    assertEquals(Wordle.score("", ""), List())

  test("Wordle.score(\"ab\", \"ab\") (2pts)"):
    assertEquals(Wordle.score("ab", "ab"), List(Green, Green))

  test("Wordle.score(\"ab\", \"ba\") (2pts)"):
    assertEquals(Wordle.score("ab", "ba"), List(Yellow, Yellow))

  test("Wordle.score(\"flask\", \"tired\") (2pts)"):
    assertEquals(
      Wordle.score("flask", "tired"),
      List(Grey, Grey, Grey, Grey, Grey)
    )

  test("Wordle.score(\"tarps\", \"party\") (2pts)"):
    assertEquals(
      Wordle.score("tarps", "party"),
      List(Yellow, Green, Green, Yellow, Grey)
    )

  test("Wordle.score(\"dries\", \"fruit\") (2pts)"):
    assertEquals(
      Wordle.score("dries", "fruit"),
      List(Grey, Green, Yellow, Grey, Grey)
    )

  test("Wordle.score(\"fumigate\", \"insulate\") (2pts)"):
    assertEquals(
      Wordle.score("fumigate", "insulate"),
      List(Grey, Yellow, Grey, Yellow, Grey, Green, Green, Green)
    )

  test("Wordle.score(\"purchasing\", \"bracketing\") (2pts)"):
    assertEquals(
      Wordle.score("purchasing", "bracketing"),
      List(Grey, Grey, Yellow, Green, Grey, Yellow, Grey, Green, Green, Green)
    )

  test("Wordle.score(\"ambidextrous\", \"demographics\") (2pts)"):
    assertEquals(
      Wordle.score("ambidextrous", "demographics"),
      List(
        Yellow,
        Yellow,
        Grey,
        Yellow,
        Yellow,
        Yellow,
        Grey,
        Grey,
        Yellow,
        Yellow,
        Grey,
        Green
      )
    )

  test(
    "Wordle.score(\"abcdefghijklmnopqrstuvwxyz\", \"zyxwvutsrqponmlkjihgfedcba\") (2pts)"
  ):
    assertEquals(
      Wordle.score("abcdefghijklmnopqrstuvwxyz", "zyxwvutsrqponmlkjihgfedcba"),
      List.fill(26)(Yellow)
    )
