package codebreaking

import GuessResult.*

class MasterMindSolveSuite extends TimedSuite(7):
  import MasterMind.*
  import MasterMind.Color.*

  test("MasterMind: Base case (1pt)"):
    assertEquals(
      MasterMind.Game(0).guess(List()),
      FoundSolution(List())
    )

  test("MasterMind: Single solution: single guess (1pt)"):
    assertEquals(
      MasterMind.Game(3).guess(
        List(ScoredGuess(List(Blue, Green, Purple), Score(3, 0)))
      ),
      FoundSolution(List(Blue, Green, Purple))
    )

  test("MasterMind: Single solution: two guesses, redundant (1pt)"):
    assertEquals(
      MasterMind.Game(3).guess(
        List(
          ScoredGuess(List(Blue, Green, Purple), Score(3, 0)),
          ScoredGuess(List(Blue, Green, Purple), Score(3, 0))
        )
      ),
      FoundSolution(List(Blue, Green, Purple))
    )

  test("MasterMind: Single solution: two guesses, required (1pt)"):
    assertEquals(
      MasterMind.Game(3).guess(
        List(
          ScoredGuess(List(Blue, Green, Purple), Score(2, 0)),
          ScoredGuess(List(Pink, Blue, Green), Score(0, 3))
        )
      ),
      FoundSolution(List(Blue, Green, Pink))
    )

  test("MasterMind: Multiple solutions (1pt)"):
    MasterMind.Game(4).guess(
      List(
        ScoredGuess(List(Blue, Blue, Blue, Blue), Score(0, 0)),
        ScoredGuess(List(Green, Green, Green, Green), Score(0, 0)),
        ScoredGuess(List(Purple, Purple, Purple, Purple), Score(0, 0)),
        ScoredGuess(List(Fuchsia, Fuchsia, Fuchsia, Fuchsia), Score(0, 0)),
        ScoredGuess(List(Pink, Pink, Pink, Pink), Score(0, 0)),
        ScoredGuess(List(White, White, Blue, Blue), Score(2, 0))
      )
    ) match
      case StillGuessing(_) => {}
      case r                => throw AssertionError(f"Unexpected response: $r")

  test("MasterMind: Single solution by elimination (1pt)"):
    assertEquals(
      MasterMind.Game(4).guess(
        List(
          ScoredGuess(List(Blue, Blue, Blue, Blue), Score(0, 0)),
          ScoredGuess(List(Green, Green, Green, Green), Score(0, 0)),
          ScoredGuess(List(Purple, Purple, Purple, Purple), Score(0, 0)),
          ScoredGuess(List(Fuchsia, Fuchsia, Fuchsia, Fuchsia), Score(0, 0)),
          ScoredGuess(List(Pink, Pink, Pink, Pink), Score(0, 0)),
          ScoredGuess(List(White, White, Brown, Brown), Score(2, 0)),
          ScoredGuess(List(Blue, Carmine, Carmine, Carmine), Score(1, 1)),
          ScoredGuess(List(Carmine, Carmine, Carmine, Blue), Score(1, 1))
        )
      ),
      FoundSolution(List(Carmine, White, Brown, Carmine))
    )

  test("MasterMind: No solutions (1pt)"):
    // Impossible score
    assertEquals(
      MasterMind.Game(3).guess(
        List(
          ScoredGuess(List(Blue, Blue, Blue), Score(0, 3))
        )
      ),
      NoSolution
    )

    // All colors eliminated
    assertEquals(
      MasterMind.Game(5).guess(
        List(
          ScoredGuess(List(Pink, Green, Carmine, Fuchsia, White), Score(0, 0)),
          ScoredGuess(List(Red, Purple, Brown, Blue, Red), Score(0, 0))
        )
      ),
      NoSolution
    )

    // Contradictions in scores
    assertEquals(
      MasterMind.Game(3).guess(
        List(
          ScoredGuess(List(Blue, Green, Purple), Score(2, 1)),
          ScoredGuess(List(Pink, Blue, Green), Score(0, 3))
        )
      ),
      NoSolution
    )

  test("MasterMind.solve(10, List(Blue)) (1pt)"):
    assertEquals(
      MasterMind.solve(10, List(Blue)),
      Some(List(Blue))
    )

  test("MasterMind.solve(100, List(Blue, Red)) (1pt)"):
    assertEquals(
      MasterMind.solve(100, List(Blue, Red)),
      Some(List(Blue, Red))
    )

  test("MasterMind.solve(16, List(Blue, Blue, Pink)) (1pt)"):
    assertEquals(
      MasterMind.solve(16, List(Blue, Blue, Pink)),
      Some(List(Blue, Blue, Pink))
    )

  test("MasterMind.solve(12, List(Brown, Green, Red, Blue)) (1pt)"):
    assertEquals(
      MasterMind.solve(12, List(Brown, Green, Red, Blue)),
      Some(List(Brown, Green, Red, Blue))
    )

  test("MasterMind.solve(12, List(Brown, Green, Brown, Blue)) (1pt)"):
    assertEquals(
      MasterMind.solve(12, List(Brown, Green, Brown, Blue)),
      Some(List(Brown, Green, Brown, Blue))
    )

  test("MasterMind.solve(8, List(Fuchsia, Green, Blue, Red)) (1pt)"):
    assertEquals(
      MasterMind.solve(8, List(Fuchsia, Green, Blue, Red)),
      Some(List(Fuchsia, Green, Blue, Red))
    )

  test("MasterMind.solve(8, List(Blue, Purple, Carmine, Purple, Purple)) (1pt)"):
    assertEquals(
      MasterMind.solve(8, List(Blue, Purple, Carmine, Purple, Purple)),
      Some(List(Blue, Purple, Carmine, Purple, Purple))
    )
