package codebreaking

object Wordle:
  type Word = String

  enum Result:
    case Grey, Yellow, Green
  type Score = List[Result]

  val allLetters = ('a' to 'z').toSet

  class Game(wordLength: Int, wordList: Set[Word]) extends Puzzle[Word, Score]:

    def score(guess: Word, secret: Word): Score =
      require(guess.length == wordLength, f"Guess length must be $wordLength.")
      require(secret.length == wordLength, f"Secret length must be $wordLength.")
      require(guess.distinct == guess, f"Guess $guess cannot have duplicates.")
      require(secret.distinct == secret, f"Secret $secret cannot have duplicates.")
      ???

    def guess(previousGuesses: List[ScoredGuess[Word, Score]]): GuessResult[Word] =
      require(
        previousGuesses.forall(_._1.length == wordLength),
        f"Previous guesses must have length $wordLength."
      )
      require(
        previousGuesses.map(_._1).forall(wordList.contains),
        "Previous guesses must all be valid words."
      )
      ???

