package codebreaking

object BullsAndCows:
  type Word = List[Int]
  case class Score(bulls: Int, cows: Int)

  val allDigits = List(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)

  class Game(wordLength: Int) extends Puzzle[Word, Score]:

    def score(guess: Word, secret: Word): Score =
      require(guess.length == wordLength, f"Guess must have length $wordLength.")
      require(secret.length == wordLength, f"Secret must have length $wordLength.")
      require(secret.distinct == secret, f"Secret $secret cannot have duplicates.")
      ???

    def guess(previousGuesses: List[ScoredGuess[Word, Score]]): GuessResult[Word] =
      require(
        previousGuesses.forall(_._1.length == wordLength),
        f"Previous guesses must have length $wordLength"
      )
      ???

