import java.util.ArrayList;
import java.util.List;
public class ParkingCorrige {

    public static void main(String[] args) {
        Parking parking = new Parking();

        parking.occuperPlaceMoto(new Motocycle(), 0, 0);
        parking.occuperPlaceMoto(new Motocycle(), 1, 0);

        //pas de places moto vide
        parking.occuperPlaceVoiture(new Voiture(), 0, 0);

        parking.occuperPlaceVoiture(new Motocycle(), 1, 0);
        
        System.out.println(parking.calculerPrixTotal(20));

    }
}


class Parking {
    private final static int PLACES_VOITURES = 5;
    private final static int PLACES_MOTOS    = 2;
    private PlaceVoiture[] placesVoiture = new PlaceVoiture[PLACES_VOITURES];
    private PlaceMotocycle[] placesMoto = new PlaceMotocycle[PLACES_MOTOS];

	// ou on peut se passer des numéros de place et faire
	// en sorte que la méthode trouve un place libre
    public void occuperPlaceVoiture(Voiture v, int i, int jourDebut) {
        if(i >= 0 && i < PLACES_VOITURES) {
			//...
    }
	public void  occuperPlaceVoiture(Motocycle v, int i, int jourDebut) {
        if(i >= 0 && i < PLACES_VOITURES) {
			//...
        }
    }
    public void occuperPlaceMoto(Motocycle m, int i, int jourDebut) {
        if(i >= 0 && i < PLACES_MOTOS) {
			//....
        }
    }

    private double calculerPrixPlace(Place[] places, int jourActuel) {
        double somme = 0.0;
        for (Place place : places) {
            if (place != null && !place.libre())
                somme += place.calculerPrix(jourActuel);
        }

        return somme;
    }

    public double calculerPrixTotal(int jourActuel) {
        double somme = 0;
        somme = calculerPrixPlace(placesVoiture, jourActuel)
                + calculerPrixPlace(placesMoto, jourActuel);
        return somme;
    }
}

abstract class Vehicule {
    public abstract double reduction(int nbJours);
}



class Voiture extends Vehicule {
    public double reduction(int nbJours) {
        if(nbJours > 15)
            return 1.5;
        return 0;
    }
}

class Motocycle  extends Vehicule {
    public double reduction(int nbJours) {
        if (nbJours > 20)
            return 1.0;
        return 0;
    }
}

abstract class Place {
    int jourDebut;
    Vehicule vehicule;
    boolean libre;


    public Place(int j) {
        jourDebut  = j;
        vehicule  = null;
        libre = true;
    }

    public boolean libre() {
        return vehicule == null;
    }

    public abstract void parquer(Vehicule v);

    // variante abstract ok, mais avec getter pour jourDebut
    public double prixJournalier(int jourActuel)
		{
			return (jourActuel - jourDebut);
		}
	

    public double calculerPrix(int jourActuel) {
        return prixJournalier(jourActuel) - vehicule.reduction(jourActuel-jourDebut);
    }

}

class PlaceVoiture extends Place {
    public PlaceVoiture(int j) {
        super(j);
    }

    public void parquer(Vehicule v) {
        if(v != null) {
            if (!( v instanceof Voiture ) &&
				!( v instanceof Motocycle))
                throw new IllegalArgumentException();
            vehicule = v;
        }
    }

    public double prixJournalier(int jourActuel) {
        return super.prixJournalier(jourActuel)*2;
    }
}
	
class PlaceMotocycle extends Place {

    public PlaceMotocycle(int j) {
        super(j);
    }
    public void parquer(Vehicule v) {
		if(v != null) {
			if (!(v  instanceof Motocycle))
				throw new IllegalArgumentException();
			vehicule = v;
		}
    }
    public double calculerPrix(int jourActuel) {
        return super.prixJournalier(jourActuel);
    }
}
