function suff_stat = my_lmmse_equalizer(rx_symbols, H, sigma2)
%MY_LMMSE_EQUALIZER implements a linear MMSE equalizer for the MIMO
%channel
%  SUFF_STAT = MY_LMMSE_EQUALIZER(RX_SYMBOLS, H, SIGMA2) computes the
%  sufficient statistic for decision according to the linear MMSE rule.
%    RX_SYMBOLS: is either a column vector or a matrix, and contains the
%    received symbols. If RX_SYMBOLS is a matrix, the function works on
%    each column separately.
%    H: is the channel matrix. It has to have the same number of rows as
%    the number of rows of RX_SYMBOLS.
%    SIGMA2: The noise variance.
%
%    SUFF_STAT: is the equalized signal, used for decision. It has the
%    same size as RX_SYMBOLS.
