# Creates usrpc struct used by the USRP transceiver

# USRP parameters. Change with care, not to burn the boards!
fc = 0.868e9  # [Hz] carrier frequency
# local oscillator offset:
# to avoid any DC correction that is happening in the AD9364 (transceiver chip in USRP B200 mini)
LOO = 400e3  # [Hz]
clockRateTx = 5e6  # [Hz] main clock
interpolationTx = 10  # upsampling factors
clockRateRx = clockRateTx
decimationRx = interpolationTx
clockInputSource = 'internal'
OutputDataTypeUSRP = 'double'
samplesPerFrameRx = 1e5  # Max is 375000 in a burst.
txRxDuration = 2  # [sec] (TX/RX on same PC)
txDuration = 100  # [sec] (TX and RX on different PCs)
rxDuration = 5   # [sec] (TX and RX on different PCs)
gainTx = 40  # [dB] (range 0:0.25:89.75)
gainRx = 40  # [dB] (range 0:1:76)

Ts = interpolationTx / clockRateTx

# Driver selection for SoapySDR
# 'uhd' for USRP
# 'bladerf' for BladeRF
# Others are available but not tested
driver = 'uhd'

# Configuration Mode if only one USRP board is available
# In case there are multiple USRP boards,
# one will be used for TX and the other for RX.
# 'TX' for transmit; 'RX' for receive ; 'TXRX' for loopback on the same board
# Default is 'TXRX'
mode_of_operation = 'TX'
