import ofdmc as ofdmc
import utilSDR
import solutions.utilUSRP as utilBlocks
import numpy as np
import utilPDC

"""
Runs the OFDM Transceiver on the TX machine
"""

ofdmc.verbose = True

filename = 'text.txt'
with open(filename) as file:
    text = file.read()

print('\nTransmitting the following text:')
print('--------------------------------')
print(text, '\n')

# convert the text to bits
txt = np.array([ord(c) for c in text])
data_bits = utilPDC.sol_de2bi(np.array([ord(c) for c in text]), 'right-msb', 8)
data_bits = data_bits.flatten('C')

n_tx_bits = data_bits.size

# randomization to ensure a balanced information sequence
np.random.seed(12345)
# data_bits = (data_bits + np.random.randint(2, size=data_bits.size)) % 2
# use this instead to generate the same random sequence as in Matlab
mask = (np.random.random((data_bits.size,)) > 0.5).astype(int)
data_bits = (data_bits + mask) % 2

tx_signal = utilBlocks.transmitter(data_bits)

rx_signal = utilSDR.runUSRPSinglePC(tx_signal, "TX")

print("Transmission done!")
