import numpy as np
import usrpc as usrpc

"""
Creates the OFDMC struct used by the OFDM transceiver
"""

# Synchronization Sequence and Training OFDM Symbol
preamble = np.array(
    [-1, -1, +1, +1, -1, +1, +1, +1, +1, +1, -1, -1, -1, +1, +1, -1, +1, -1, +1, +1, -1, +1, +1, -1, -1, -1, -1, +1, +1,
     -1, +1, -1, +1, +1, +1, -1, +1, +1, -1, -1, -1, -1, -1, +1, -1, +1, -1, +1, -1, -1, +1, -1, +1, +1, +1, -1, +1, +1,
     +1, -1, +1, -1, +1, -1, +1, -1, +1, -1, -1, +1, +1, -1, +1, +1, +1, -1, -1, -1, -1, +1, -1, +1, +1, -1, -1, -1, -1,
     -1, -1, +1, -1, -1, +1, -1, -1, -1, +1, +1, -1, -1, +1, -1, -1, -1, -1, -1, +1, +1, -1, +1, -1, +1, -1, +1, -1, +1,
     +1, +1, +1, -1, +1, +1, +1, +1, +1, +1, +1, +1, -1, -1, -1, +1, -1, +1, -1, +1, +1, -1, +1, +1, +1, -1, +1, +1, -1,
     -1, +1, -1, -1, -1, -1, +1, +1, +1, +1, +1, -1, -1, -1, -1, +1, -1, +1, -1, -1, -1, +1, +1, -1, -1, +1, +1, -1, -1,
     -1, -1, +1, -1, -1, +1, +1, +1, +1, +1, +1, +1, -1, +1, -1, -1, -1, -1, +1, +1, -1, -1, -1, -1, -1, +1, -1, +1, -1,
     +1, +1, -1, -1, +1, +1, +1, -1, +1, -1, -1, +1, -1, -1, -1, +1, +1, +1, -1, -1, +1, -1, -1, -1, -1, +1, -1, +1, -1,
     +1, +1, +1, -1, +1, -1, +1, -1, -1, +1, +1, +1, +1, +1, -1, +1, +1, +1, +1, +1, +1, +1, +1, -1, +1, +1, +1, +1, +1,
     +1, -1, -1, +1, +1, +1, -1, -1, -1, +1, -1, -1, +1, +1, +1, +1, +1, +1, -1, -1, -1, +1, +1, +1, -1, -1, +1, -1, -1,
     -1, -1, -1, -1, -1, -1, -1, +1, -1, +1, +1, -1, -1, -1, +1, -1, +1, +1, -1, +1, -1, -1, +1, -1, -1, +1, +1, +1, +1,
     -1, +1, -1, +1, -1, +1, -1, -1, +1, +1, +1, -1, +1, +1, -1, -1, -1, +1, +1, -1, +1, -1, -1, +1, -1, -1, -1, +1, -1,
     -1, +1, +1, +1, -1, -1, -1, +1, -1, -1, -1, +1, -1, -1, -1, -1, +1, +1, +1, +1, -1, -1, +1, -1, -1, +1, +1, +1, +1,
     -1, -1, +1, +1, -1, +1, +1, -1, +1, +1, -1, +1, +1, +1, +1, +1, -1, -1, +1, -1, -1, +1, -1, +1, +1, -1, +1, -1, -1,
     +1, -1, -1, -1, -1, +1, +1, +1, -1, +1, -1, -1, -1, +1, +1, +1, +1, +1, +1, -1, +1, -1, +1, +1, -1, +1, +1, -1, -1,
     -1, -1, -1, -1, +1, +1, +1, +1, +1, -1, +1, -1, +1, -1, +1, -1, -1, -1, +1, +1, -1, -1, -1, -1, -1, +1, -1, +1, -1,
     -1, -1, -1, -1, +1, +1, -1, -1, +1, +1, -1, -1, +1, +1, +1, -1, -1, -1, +1, +1, +1, -1, -1, +1, -1, -1, +1, -1, +1,
     -1, +1, -1, +1, -1, -1, +1, -1, -1, +1, +1, +1, -1, -1, +1, -1, -1, -1, +1, -1, -1, -1, +1, +1, +1, +1, +1, +1, +1,
     +1, +1, +1, +1, -1, +1, -1, -1, +1, +1, -1, -1, +1, -1, -1, +1, +1, -1, -1, -1, +1, -1, -1, +1, -1, +1, +1, +1, +1,
     +1, -1, +1, -1, +1, -1, +1, -1, -1, -1, +1, -1, +1, -1, -1, -1, +1, -1, +1, +1, -1, +1, -1, +1, +1, +1, -1, -1, -1,
     +1, +1, -1, -1, -1, +1, +1, +1, -1, +1, +1, -1, +1, -1, +1, +1, +1, -1, +1, -1, +1, +1, -1, +1, -1, -1, +1, -1, +1,
     +1, +1, +1, -1, +1, -1, +1, -1, -1, +1, -1, -1, +1, -1, +1, -1, -1, +1, -1, -1, +1, +1, +1, -1, -1, -1, +1, +1, -1,
     -1, -1, -1, +1, -1, -1, +1, +1, -1, +1, +1, +1, +1, -1, -1, -1, -1, -1, -1, +1, +1, -1, +1, -1, -1, +1, -1, +1, +1,
     +1, -1, +1, +1, +1, +1, -1, -1, -1, -1, -1, +1, -1, +1, -1, +1, -1, -1, -1, +1, +1, -1, -1, +1, +1, -1, +1, +1, -1,
     +1, +1, -1, +1, +1, -1, +1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, +1, +1, +1, +1, -1, -1, -1, -1, -1, +1, -1, -1,
     -1, -1, +1, +1, +1, -1, -1, +1, -1, -1, -1, +1, +1, -1, +1, -1, -1, +1, +1, +1, +1, -1, -1, -1, +1, +1, -1, +1, -1,
     +1, -1, +1, +1, +1, +1, -1, +1, -1, +1, +1, -1, +1, -1, +1, -1, -1, -1, -1, -1, -1, +1, +1, +1, -1, -1, -1, -1, +1,
     -1, -1, +1, -1, +1, +1, -1, -1, -1, +1, -1, -1, +1, +1, -1, -1, -1, -1, -1, -1, +1, -1, -1, -1, -1, -1, +1, -1, +1,
     +1, +1, -1, -1, +1, +1, +1, -1, -1, -1, -1, -1, +1, +1, +1, +1, +1, +1, +1, -1, +1, +1, -1, +1, -1, +1, +1, +1, -1,
     +1, -1, -1, +1, -1, +1, +1, +1, -1, +1, +1, +1, -1, +1, +1, -1, -1, +1, -1, -1, +1, +1, +1, +1, +1, +1, -1, -1, -1,
     +1, -1, -1, +1, -1, +1, +1, +1, -1, -1, +1, -1, +1, +1, +1, -1, +1, +1, -1, +1, +1, +1, -1, -1, -1, +1, +1, +1, -1,
     +1, -1, -1, +1, +1, -1, -1, +1, +1, -1, +1, +1, -1, -1, -1, -1, +1, +1, -1, -1, +1, -1, -1, -1, -1, -1, -1, +1, +1,
     -1, -1, +1, +1, -1, +1, -1, +1, +1, -1, -1, +1, -1, +1, +1, -1, -1, +1, -1, +1, -1, -1, -1, -1, +1, +1, -1, -1, +1,
     -1, -1, +1, -1, +1, -1, +1, +1, -1, -1, -1, +1, -1, -1, -1, -1, +1, +1, +1, -1, -1, +1, -1, +1, -1, +1, +1, +1, -1,
     +1, +1, +1, +1, -1, +1, +1, +1, -1, +1, +1, -1, +1, +1, -1, -1, -1, +1, +1, +1, +1, -1, -1, -1, +1, +1, -1, +1, -1,
     +1, +1, +1, -1, +1, +1, +1, +1])

fullTrainingSymbol = np.array(
    [+1 + 1j, -1 - 1j, +1 - 1j, +1 + 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j,
     +1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, +1 - 1j, -1 - 1j, +1 - 1j, -1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j,
     +1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, +1 - 1j, +1 + 1j, +1 + 1j, -1 + 1j,
     -1 - 1j, +1 - 1j, -1 - 1j, -1 - 1j, +1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j,
     -1 - 1j, -1 + 1j, +1 + 1j, -1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j, +1 + 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 + 1j,
     +1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 - 1j, -1 - 1j, -1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j,
     +1 - 1j, -1 - 1j, +1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j,
     -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j,
     -1 + 1j, -1 - 1j, +1 + 1j, -1 - 1j, +1 - 1j, -1 - 1j, -1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j,
     +1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 + 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j,
     +1 + 1j, +1 - 1j, +1 - 1j, -1 + 1j, -1 - 1j, +1 + 1j, -1 - 1j, +1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j, -1 - 1j,
     +1 + 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j, +1 + 1j,
     -1 + 1j, +1 - 1j, +1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j,
     -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, +1 + 1j, -1 - 1j, -1 + 1j, -1 - 1j,
     -1 - 1j, -1 - 1j, -1 + 1j, -1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j,
     -1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j, +1 + 1j, -1 + 1j, +1 + 1j, -1 - 1j, +1 - 1j,
     +1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 + 1j, -1 - 1j,
     +1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j,
     +1 - 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, +1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j,
     +1 - 1j, -1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j,
     +1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j,
     -1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 + 1j, +1 - 1j, +1 + 1j, +1 + 1j, -1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j,
     -1 - 1j, +1 - 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j,
     -1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, -1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, -1 - 1j, -1 + 1j,
     +1 + 1j, +1 - 1j, +1 + 1j, -1 + 1j, -1 - 1j, -1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 + 1j, +1 + 1j, -1 + 1j,
     +1 + 1j, -1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, -1 + 1j,
     +1 - 1j, +1 - 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j,
     +1 + 1j, +1 - 1j, -1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j,
     +1 + 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j,
     -1 + 1j, -1 + 1j, +1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, -1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, -1 - 1j,
     +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j,
     -1 + 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, +1 + 1j, +1 + 1j, -1 - 1j, +1 - 1j, -1 - 1j,
     +1 - 1j, +1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, +1 + 1j, -1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j,
     -1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j, +1 - 1j, +1 + 1j,
     -1 + 1j, -1 + 1j, -1 - 1j, +1 - 1j, -1 - 1j, +1 + 1j, -1 - 1j, +1 + 1j, -1 + 1j, +1 + 1j, -1 - 1j, +1 + 1j,
     -1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j, +1 + 1j, -1 - 1j, +1 + 1j, +1 + 1j,
     +1 - 1j, +1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j, +1 - 1j, -1 - 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 + 1j,
     +1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j,
     +1 - 1j, -1 + 1j, -1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j,
     +1 - 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j,
     +1 + 1j, -1 + 1j, +1 + 1j, -1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, +1 - 1j,
     +1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j,
     +1 - 1j, +1 - 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j,
     +1 - 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j,
     -1 - 1j, +1 + 1j, -1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j,
     +1 + 1j, -1 - 1j, +1 - 1j, +1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j,
     -1 - 1j, +1 + 1j, -1 - 1j, +1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 - 1j, +1 - 1j, +1 - 1j, -1 - 1j,
     +1 - 1j, -1 + 1j, -1 - 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j, -1 + 1j,
     -1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 + 1j, -1 + 1j, +1 + 1j, -1 + 1j, +1 + 1j, -1 + 1j,
     +1 + 1j, +1 - 1j, -1 - 1j, +1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j,
     +1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, -1 + 1j, +1 - 1j, +1 + 1j,
     +1 - 1j, +1 + 1j, -1 + 1j, +1 + 1j, -1 - 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 + 1j, -1 - 1j, -1 + 1j, +1 - 1j,
     -1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, -1 + 1j, -1 - 1j,
     +1 - 1j, -1 + 1j, +1 - 1j, +1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j, +1 - 1j,
     -1 + 1j, +1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 - 1j,
     -1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j, +1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j, -1 + 1j, +1 - 1j, -1 + 1j,
     -1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, +1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j,
     -1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, -1 - 1j, +1 - 1j, +1 + 1j, -1 + 1j,
     +1 - 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j,
     +1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, +1 - 1j,
     +1 - 1j, +1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 - 1j, +1 - 1j,
     -1 + 1j, -1 - 1j, -1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, -1 + 1j, +1 + 1j,
     -1 - 1j, +1 - 1j, +1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j, +1 - 1j,
     +1 + 1j, +1 - 1j, -1 + 1j, +1 + 1j, +1 + 1j, -1 - 1j, +1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, -1 + 1j, +1 + 1j,
     -1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j, +1 - 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 + 1j, +1 - 1j, -1 + 1j,
     -1 + 1j, +1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 + 1j, +1 - 1j,
     -1 + 1j, +1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j, -1 + 1j, -1 - 1j, +1 - 1j, -1 + 1j, +1 - 1j, -1 + 1j,
     +1 + 1j, +1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j,
     +1 + 1j, -1 + 1j, -1 + 1j, +1 - 1j, +1 + 1j, -1 + 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 - 1j, +1 - 1j, -1 - 1j,
     +1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j,
     -1 + 1j, -1 - 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 + 1j,
     -1 - 1j, +1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j, +1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, +1 - 1j,
     -1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, +1 + 1j, +1 - 1j, +1 - 1j,
     +1 + 1j, -1 + 1j, +1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, +1 - 1j, -1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 + 1j,
     -1 + 1j, +1 - 1j, -1 - 1j, +1 - 1j, -1 - 1j, +1 - 1j, -1 - 1j, +1 - 1j, +1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j,
     -1 + 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, +1 + 1j, -1 - 1j, -1 - 1j,
     -1 - 1j, -1 + 1j, +1 - 1j, +1 - 1j, -1 + 1j, +1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, +1 + 1j, -1 + 1j, -1 + 1j,
     +1 + 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 - 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 - 1j, +1 + 1j, -1 + 1j, -1 + 1j,
     +1 - 1j, -1 + 1j, -1 + 1j, +1 + 1j, -1 - 1j, +1 - 1j, +1 - 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 + 1j, +1 - 1j,
     -1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 + 1j, +1 + 1j, -1 + 1j, -1 - 1j, +1 - 1j,
     +1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 + 1j, -1 - 1j,
     -1 - 1j, -1 - 1j, -1 + 1j, +1 + 1j, +1 - 1j, +1 + 1j, -1 + 1j, -1 - 1j, -1 - 1j, +1 + 1j, +1 - 1j, -1 + 1j,
     +1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, +1 - 1j, -1 + 1j, +1 + 1j, +1 - 1j, +1 + 1j, +1 + 1j, +1 - 1j, -1 - 1j,
     -1 - 1j, +1 - 1j, +1 - 1j, +1 - 1j, -1 + 1j, -1 + 1j, -1 - 1j, +1 + 1j, -1 + 1j, +1 + 1j, +1 - 1j, -1 + 1j,
     -1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 - 1j, -1 - 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, -1 + 1j, +1 + 1j,
     -1 + 1j, -1 - 1j, -1 - 1j, -1 + 1j]) / np.sqrt(2)

# OFDM Parameters
nCarriers = int(1024)
cpLength = int(20)
nDataOFDMSymbols = int(30)  # No. data symbols
nTrainingOFDMSymbols = int(1)  # No. training symbols before data symbols
nOFDMSymbols = nDataOFDMSymbols + nTrainingOFDMSymbols

# PSD mask to not use highly noise carriers
psdMask = np.ones(1024)
psdMask[:100] = 0  # DC Carriers
psdMask[416:607] = 0  # Edges of the spectrum
psdMask[925:] = 0  # DC Carriers
nUsefulCarriers = np.sum(psdMask)

psdMaskTmp = psdMask > 0  # transform to logical

pilotIndices = np.array([100, 924])
pilotSymbols = fullTrainingSymbol[pilotIndices]

# DATA mask indicates where we have data carriers
# Pay attention that by modifying dataMask, we modify psdMaskTmp!!!
dataMask = psdMaskTmp.copy()
dataMask[pilotIndices] = False

trainingSymbols = fullTrainingSymbol[psdMaskTmp]
nZeros = 0  # 2*(nCarriers + cpLength)  # for noise estimation

# Data Modulation
constellationType = 'qam'  # constellation type ('qam' or 'psk')
M = 4  # modulation order
# total number of data bits we can transmit
nDataBits = int(nDataOFDMSymbols * (nUsefulCarriers - pilotIndices.size) * np.log2(M))
# text bits: hardcoded to the text file we have
nTextBits = int(37632)
# We use it at Rx in order to avoid printing garbage after the useful text
# (we pad the text with random bits to match the length of the OFDM blocks).

# Computed Parameters
# 1. Total length of TX signal
txSignalLength = preamble.size + nZeros + nOFDMSymbols * (nCarriers + cpLength)
# 2. Sampling period
T = usrpc.Ts  # [s]
# 3. The precision of CFO estimation
fCorr = 0.1 / (T * preamble.size)  # [Hz]
rangeCFO = np.arange(-1200, 1200, fCorr)  # [Hz] (Usually the CFO is not more than 1.2kHz)

verbose = False
