function usrpTx(samplesIn)
% USRP transmitter

global usrpc;

if isempty(usrpc)
    usrpConfig();
end

fprintf(1,'Tx over USRP, duration of %i [seconds].\n', usrpc.txDuration);
% repeat the data such that we have a Tx time of usrpc.txRxDuration
noRepData = ceil(usrpc.txDuration/(usrpc.Ts*length(samplesIn)));
noRepData = max(10, noRepData); % to be sure we repeat it at least 10 times
fprintf(1,'Repeating the data %i times.\n', noRepData);

dataToTx = repmat(samplesIn, 1, noRepData);

%% USRP settings

% find connected radios
connectedRadios = findsdru

usrpBoardPlatform = connectedRadios.Platform; % Or one can set it by hand, e.g.: 'B200';
usrpBoardSerialNumTx = connectedRadios.SerialNum; % Or one can set it by hand, e.g.: '30C51BC';

% configure the Tx object
tx = comm.SDRuTransmitter(...
    'Platform',usrpBoardPlatform, ...
    'CenterFrequency',usrpc.fc, ...
    'LocalOscillatorOffset',usrpc.LOO,...
    'InterpolationFactor',usrpc.interpolationTx, ...
    'MasterClockRate', usrpc.clockRateTx,...
    'SerialNum', usrpBoardSerialNumTx,...
    'Gain', usrpc.gainTx,...
    'ClockSource', usrpc.clockInputSource,...
    'UnderrunOutputPort', true)

% Check if the parameters were set correctly
TxInfo = info(tx)

% Tx

noFrames = floor(length(dataToTx)/usrpc.samplesPerFrameRx);
for l = 1:noFrames
    dataTxUSRP = tx(dataToTx(1+(l-1)*usrpc.samplesPerFrameRx:l*usrpc.samplesPerFrameRx).');
    fprintf(1, 'Tx frame %i out of %i. \n', l, noFrames);
end

% release the objects
release(tx)

end
