function [dataOut] = usrpRx(lengthDataOut)
% USRP receiver

global usrpc;

if isempty(usrpc)
    usrpConfig();
end


fprintf(1,'Rx over USRP, duration of %i [seconds].\n', usrpc.rxDuration);

% calculate the number of samples we get
noSamples = floor(usrpc.rxDuration/(usrpc.Ts));
fprintf(1,'USRP will receive %i samples.\n', noSamples);

%% USRP settings

% find connected radios
connectedRadios = findsdru

usrpBoardPlatform = connectedRadios.Platform; % Or one can set it by hand, e.g.: 'B200';
usrpBoardSerialNumRx = connectedRadios.SerialNum; % Or one can set it by hand, e.g.: '30C5426';

% configure the Rx object
rx = comm.SDRuReceiver(...
    'Platform',usrpBoardPlatform, ...
    'CenterFrequency',usrpc.fc, ...
    'LocalOscillatorOffset', usrpc.LOO,...
    'MasterClockRate', usrpc.clockRateRx,...
    'SerialNum', usrpBoardSerialNumRx,...
    'DecimationFactor', usrpc.decimationRx,...
    'Gain', usrpc.gainRx,...
    'SamplesPerFrame', usrpc.samplesPerFrameRx,...
    'ClockSource', usrpc.clockInputSource,...
    'OutputDataType', usrpc.OutputDataTypeUSRP,...
    'OverrunOutputPort', true)

% Check if the parameters were set correctly
RxInfo = info(rx)

% Rx
noFrames = floor(noSamples/rx.SamplesPerFrame);
dataRx = zeros(1, noFrames*rx.SamplesPerFrame);
l = 1; w = 1;
while l <= noFrames
    [dataRxUSRP, len] = rx();
    % fprintf(1,'While loop %i. \n', w); % to check how much is waiting
    % for the rx() to receive something
    w = w+1;
    if len > 0
        dataRx(1+(l-1)*rx.SamplesPerFrame:l*rx.SamplesPerFrame) = dataRxUSRP.';
        fprintf(1, 'Rx frame %i out of %i. \n', l, noFrames);
        l = l+1;
    end
end

% release the objects
release(rx)

% dataRxUSRP = dataRxUSRP - mean(dataRxUSRP); % remove DC offset
% dataRxUSRP = dataRxUSRP/var(dataRxUSRP); % set to var 1

% scatter plot to check if no ADC saturation happened
scatterplot(dataRx);
grid on; title('Received Sequence');



% drop some data to avoid the transients at the end
stopData = length(dataRx) - floor(rx.SamplesPerFrame/2);
startData = stopData - lengthDataOut + 1;
dataRx1 = dataRx(startData:stopData);

figure;
hax=axes;
plot(abs(dataRx)); grid on; title('Rx data: vertical bars show selected data')
hold on; xlabel('Time'); ylabel('Magnitude');
VL1 = startData;
VL2 = stopData;
line([VL1 VL1],get(hax,'YLim'), 'Color', [1 0 0]);
line([VL2 VL2],get(hax,'YLim'), 'Color', [1 0 0]);

% plot the spectrum of the Rx data
fso = 1/usrpc.Ts; N = length(dataRx);
freqLineo = [-fso/2:fso/N:fso/2-fso/N];
figure;
plot(freqLineo, fftshift(abs(fft(dataRx))));
grid on; xlabel('f [Hz]'); ylabel('Magnitude'); title('OFDM Rx Spectrum');

%dataRx = dataRx - mean(dataRx);
dataOut = dataRx1;

end
