% Tests the OFDM Transceiver using simulated channel

clear all;
close all;

% load TX/RX settings
global ofdmc;
ofdmConfig();
% show info for debugging
ofdmc.verbose = 1;

% channel parameters
SNR        = 20;  % [dB]
CFO        = 543; % [Hz] (carrier frequency offset)
ClkOffset  = 3;   % [samples] (sampling clock offset) 

  
% generate new bits
data_bits = randi([0,1],ofdmc.nDataBits,1);
tx_signal = transmitter(data_bits);

rx_signal = channelSimulator(tx_signal, SNR, CFO, ClkOffset);

est_bits = receiver(rx_signal);

% check if everything is correct.
fprintf('%d bits transmitted, %d bits decoded incorreclty, BER = %g\n',...
    numel(data_bits), sum(data_bits ~= est_bits), ...
    1.0*sum(data_bits ~= est_bits)/numel(data_bits));