% Runs the OFDM Transceiver on a single machine (with one or more USRP boards)

clear all;
close all;

% load TX/RX settings
global ofdmc;
ofdmConfig();

% show info for debugging
ofdmc.verbose = 1;


% transmit a text file:
text = fileread('text.txt');

fprintf('Transmitting the following text:\n');
fprintf('--------------------------------\n');
fprintf('%s',text);

data_bits = sol_de2bi(uint8(text),'right-msb',8);
data_bits = reshape(transpose(data_bits),1,[]);

%data_bits = data_bits(:);
n_tx_bits = numel(data_bits);

% randomization to ensure a balanced information sequence
rng(12345);
% data_bits = mod(data_bits + randi([0 1], size(data_bits)), 2);
% use this instead to generate the same random sequence as in Python
data_bits = mod(data_bits + (rand(size(data_bits)) > 0.5), 2);

tx_signal = transmitter(data_bits);
rx_signal = usrpTxRx(tx_signal);
%rx_signal  = channelSimulator(tx_signal,50);

est_bits = receiver(rx_signal);

% remove the padded bits
est_bits = est_bits(1:n_tx_bits);

% check if everything is correct.
fprintf('%d bits transmitted, %d bits decoded incorreclty, BER = %g\n',...
    numel(data_bits), sum(data_bits(:) ~= est_bits(:)), ...
    1.0*sum(data_bits(:) ~= est_bits(:))/numel(data_bits));

% undo randomization
rng(12345);
% est_bits = mod(est_bits + randi([0 1], size(est_bits)), 2);
% use this instead to generate the same random sequence as in Python
est_bits = mod(est_bits + (rand(size(est_bits)) > 0.5), 2);

rx_bits  = transpose(reshape(est_bits,8,[]));
rx_chars = sol_bi2de(rx_bits,'right-msb');
rx_text  = uint8(rx_chars)';


fprintf('\n\nReceived the following text:\n');
fprintf('--------------------------------\n');
fprintf('%s',rx_text);
fprintf('\n--------------------------------\n');

    
