% Runs the OFDM Transceiver on the RX machine

clear all;
close all;

% load TX/RX settings
global ofdmc;
ofdmConfig();

% show info for debugging
ofdmc.verbose = 1;

rx_signal = usrpRx(4*ofdmc.txSignalLength);
%rx_signal  = channelSimulator(tx_signal,50);

est_bits = receiver(rx_signal);

% remove the padded bits
est_bits = est_bits(1:ofdmc.nTextBits);

% undo randomization (see run_tx)
rng(12345);
% est_bits = mod(est_bits + randi([0 1], size(est_bits)), 2);
% use this instead to generate the same random sequence as in Python
est_bits = mod(est_bits + (rand(size(est_bits)) > 0.5), 2);

rx_bits  = transpose(reshape(est_bits,8,[]));
rx_chars = sol_bi2de(rx_bits,'right-msb');
rx_text  = uint8(rx_chars)';


fprintf('\n\nReceived the following text:\n');
fprintf('--------------------------------\n');
fprintf('%s',rx_text);
fprintf('\n--------------------------------\n');