function ofdmConfig()
%OFDMCONFIG Creates OFDMC struct used by the OFDM transceiver


global ofdmc;

if ~isempty(ofdmc)
    return;
end


ofdmc.verbose = 1;


%% Synchronization Sequence and Training OFDM Symbol
ofdmc.preamble = [-1,-1,+1,+1,-1,+1,+1,+1,+1,+1,-1,-1,-1,+1,+1,-1,...  
	+1,-1,+1,+1,-1,+1,+1,-1,-1,-1,-1,+1,+1,-1,+1,-1,...
	+1,+1,+1,-1,+1,+1,-1,-1,-1,-1,-1,+1,-1,+1,-1,+1,...
	-1,-1,+1,-1,+1,+1,+1,-1,+1,+1,+1,-1,+1,-1,+1,-1,...
	+1,-1,+1,-1,-1,+1,+1,-1,+1,+1,+1,-1,-1,-1,-1,+1,...
	-1,+1,+1,-1,-1,-1,-1,-1,-1,+1,-1,-1,+1,-1,-1,-1,...
	+1,+1,-1,-1,+1,-1,-1,-1,-1,-1,+1,+1,-1,+1,-1,+1,...
	-1,+1,-1,+1,+1,+1,+1,-1,+1,+1,+1,+1,+1,+1,+1,+1,...
	-1,-1,-1,+1,-1,+1,-1,+1,+1,-1,+1,+1,+1,-1,+1,+1,...
	-1,-1,+1,-1,-1,-1,-1,+1,+1,+1,+1,+1,-1,-1,-1,-1,...
	+1,-1,+1,-1,-1,-1,+1,+1,-1,-1,+1,+1,-1,-1,-1,-1,...
	+1,-1,-1,+1,+1,+1,+1,+1,+1,+1,-1,+1,-1,-1,-1,-1,...
	+1,+1,-1,-1,-1,-1,-1,+1,-1,+1,-1,+1,+1,-1,-1,+1,...
	+1,+1,-1,+1,-1,-1,+1,-1,-1,-1,+1,+1,+1,-1,-1,+1,...
	-1,-1,-1,-1,+1,-1,+1,-1,+1,+1,+1,-1,+1,-1,+1,-1,...
	-1,+1,+1,+1,+1,+1,-1,+1,+1,+1,+1,+1,+1,+1,+1,-1,...
	+1,+1,+1,+1,+1,+1,-1,-1,+1,+1,+1,-1,-1,-1,+1,-1,...
	-1,+1,+1,+1,+1,+1,+1,-1,-1,-1,+1,+1,+1,-1,-1,+1,...
	-1,-1,-1,-1,-1,-1,-1,-1,-1,+1,-1,+1,+1,-1,-1,-1,...
	+1,-1,+1,+1,-1,+1,-1,-1,+1,-1,-1,+1,+1,+1,+1,-1,...
	+1,-1,+1,-1,+1,-1,-1,+1,+1,+1,-1,+1,+1,-1,-1,-1,...
	+1,+1,-1,+1,-1,-1,+1,-1,-1,-1,+1,-1,-1,+1,+1,+1,...
	-1,-1,-1,+1,-1,-1,-1,+1,-1,-1,-1,-1,+1,+1,+1,+1,...
	-1,-1,+1,-1,-1,+1,+1,+1,+1,-1,-1,+1,+1,-1,+1,+1,...
	-1,+1,+1,-1,+1,+1,+1,+1,+1,-1,-1,+1,-1,-1,+1,-1,...
	+1,+1,-1,+1,-1,-1,+1,-1,-1,-1,-1,+1,+1,+1,-1,+1,...
	-1,-1,-1,+1,+1,+1,+1,+1,+1,-1,+1,-1,+1,+1,-1,+1,...
	+1,-1,-1,-1,-1,-1,-1,+1,+1,+1,+1,+1,-1,+1,-1,+1,...
	-1,+1,-1,-1,-1,+1,+1,-1,-1,-1,-1,-1,+1,-1,+1,-1,...
	-1,-1,-1,-1,+1,+1,-1,-1,+1,+1,-1,-1,+1,+1,+1,-1,...
	-1,-1,+1,+1,+1,-1,-1,+1,-1,-1,+1,-1,+1,-1,+1,-1,...
	+1,-1,-1,+1,-1,-1,+1,+1,+1,-1,-1,+1,-1,-1,-1,+1,...
	-1,-1,-1,+1,+1,+1,+1,+1,+1,+1,+1,+1,+1,+1,-1,+1,...
	-1,-1,+1,+1,-1,-1,+1,-1,-1,+1,+1,-1,-1,-1,+1,-1,...
	-1,+1,-1,+1,+1,+1,+1,+1,-1,+1,-1,+1,-1,+1,-1,-1,...
	-1,+1,-1,+1,-1,-1,-1,+1,-1,+1,+1,-1,+1,-1,+1,+1,...
	+1,-1,-1,-1,+1,+1,-1,-1,-1,+1,+1,+1,-1,+1,+1,-1,...
	+1,-1,+1,+1,+1,-1,+1,-1,+1,+1,-1,+1,-1,-1,+1,-1,...
	+1,+1,+1,+1,-1,+1,-1,+1,-1,-1,+1,-1,-1,+1,-1,+1,...
	-1,-1,+1,-1,-1,+1,+1,+1,-1,-1,-1,+1,+1,-1,-1,-1,...
	-1,+1,-1,-1,+1,+1,-1,+1,+1,+1,+1,-1,-1,-1,-1,-1,...
	-1,+1,+1,-1,+1,-1,-1,+1,-1,+1,+1,+1,-1,+1,+1,+1,...
	+1,-1,-1,-1,-1,-1,+1,-1,+1,-1,+1,-1,-1,-1,+1,+1,...
	-1,-1,+1,+1,-1,+1,+1,-1,+1,+1,-1,+1,+1,-1,+1,-1,...
	-1,-1,-1,-1,-1,-1,-1,-1,-1,+1,+1,+1,+1,-1,-1,-1,...
	-1,-1,+1,-1,-1,-1,-1,+1,+1,+1,-1,-1,+1,-1,-1,-1,...
	+1,+1,-1,+1,-1,-1,+1,+1,+1,+1,-1,-1,-1,+1,+1,-1,...
	+1,-1,+1,-1,+1,+1,+1,+1,-1,+1,-1,+1,+1,-1,+1,-1,...
	+1,-1,-1,-1,-1,-1,-1,+1,+1,+1,-1,-1,-1,-1,+1,-1,...
	-1,+1,-1,+1,+1,-1,-1,-1,+1,-1,-1,+1,+1,-1,-1,-1,...
	-1,-1,-1,+1,-1,-1,-1,-1,-1,+1,-1,+1,+1,+1,-1,-1,...
	+1,+1,+1,-1,-1,-1,-1,-1,+1,+1,+1,+1,+1,+1,+1,-1,...
	+1,+1,-1,+1,-1,+1,+1,+1,-1,+1,-1,-1,+1,-1,+1,+1,...
	+1,-1,+1,+1,+1,-1,+1,+1,-1,-1,+1,-1,-1,+1,+1,+1,...
	+1,+1,+1,-1,-1,-1,+1,-1,-1,+1,-1,+1,+1,+1,-1,-1,...
	+1,-1,+1,+1,+1,-1,+1,+1,-1,+1,+1,+1,-1,-1,-1,+1,...
	+1,+1,-1,+1,-1,-1,+1,+1,-1,-1,+1,+1,-1,+1,+1,-1,...
	-1,-1,-1,+1,+1,-1,-1,+1,-1,-1,-1,-1,-1,-1,+1,+1,...
	-1,-1,+1,+1,-1,+1,-1,+1,+1,-1,-1,+1,-1,+1,+1,-1,...
	-1,+1,-1,+1,-1,-1,-1,-1,+1,+1,-1,-1,+1,-1,-1,+1,...
	-1,+1,-1,+1,+1,-1,-1,-1,+1,-1,-1,-1,-1,+1,+1,+1,...
	-1,-1,+1,-1,+1,-1,+1,+1,+1,-1,+1,+1,+1,+1,-1,+1,...
	+1,+1,-1,+1,+1,-1,+1,+1,-1,-1,-1,+1,+1,+1,+1,-1,...
	-1,-1,+1,+1,-1,+1,-1,+1,+1,+1,-1,+1,+1,+1,+1];

ofdmc.fullTrainingSymbol = ...
	[+1+1i,-1-1i,+1-1i,+1+1i,-1+1i,-1-1i,-1-1i,-1-1i,-1+1i,+1+1i,+1-1i,-1-1i,+1-1i,-1+1i,-1+1i,-1+1i,...
	-1+1i,+1-1i,-1-1i,+1-1i,-1+1i,+1-1i,+1-1i,+1-1i,+1-1i,-1-1i,-1+1i,+1-1i,-1-1i,-1+1i,+1-1i,-1+1i,...
	+1-1i,+1+1i,+1+1i,-1+1i,-1-1i,+1-1i,-1-1i,-1-1i,+1+1i,-1-1i,+1-1i,+1-1i,+1+1i,+1+1i,+1+1i,+1-1i,...
	-1-1i,-1+1i,+1+1i,-1+1i,+1-1i,-1-1i,-1-1i,+1+1i,-1-1i,-1-1i,-1+1i,-1+1i,+1+1i,+1-1i,+1+1i,+1-1i,...
	-1-1i,+1-1i,+1-1i,-1-1i,-1-1i,+1-1i,+1+1i,+1-1i,+1-1i,-1-1i,+1+1i,-1+1i,-1+1i,-1-1i,+1-1i,+1-1i,...
	+1+1i,+1+1i,+1+1i,+1+1i,-1-1i,-1-1i,-1-1i,-1+1i,+1+1i,+1-1i,+1-1i,-1-1i,-1+1i,+1+1i,-1+1i,-1+1i,...
	-1+1i,-1-1i,+1+1i,-1-1i,+1-1i,-1-1i,-1-1i,+1-1i,+1+1i,+1-1i,-1-1i,-1-1i,+1+1i,-1+1i,-1+1i,-1-1i,...
	-1+1i,-1+1i,+1-1i,-1+1i,-1+1i,-1-1i,-1-1i,+1+1i,+1+1i,+1-1i,+1-1i,-1+1i,-1-1i,+1+1i,-1-1i,+1-1i,...
	-1+1i,-1-1i,-1+1i,-1-1i,+1+1i,+1-1i,+1-1i,+1+1i,+1+1i,+1+1i,-1+1i,+1-1i,-1+1i,-1-1i,-1+1i,+1+1i,...
	-1+1i,+1-1i,+1+1i,-1-1i,-1-1i,+1+1i,-1-1i,-1-1i,+1+1i,+1-1i,+1+1i,+1-1i,-1-1i,-1-1i,-1-1i,-1+1i,...
	-1-1i,-1-1i,+1+1i,+1-1i,+1+1i,-1-1i,-1+1i,-1-1i,-1-1i,-1-1i,-1+1i,-1+1i,+1+1i,-1-1i,-1-1i,+1-1i,...
	-1-1i,-1-1i,-1-1i,-1-1i,-1+1i,-1+1i,-1+1i,-1-1i,-1+1i,+1-1i,-1-1i,+1+1i,-1+1i,+1+1i,-1-1i,+1-1i,...
	+1+1i,-1-1i,-1-1i,-1-1i,-1-1i,-1-1i,-1+1i,-1+1i,-1+1i,+1+1i,+1+1i,-1-1i,+1+1i,-1-1i,-1-1i,+1+1i,...
	+1+1i,-1-1i,-1+1i,-1-1i,-1+1i,+1-1i,+1+1i,+1-1i,+1-1i,+1-1i,-1-1i,-1-1i,-1-1i,+1-1i,-1+1i,+1-1i,...
	-1-1i,-1-1i,-1+1i,+1+1i,+1-1i,-1+1i,+1+1i,-1-1i,-1-1i,-1-1i,+1+1i,+1-1i,-1-1i,-1+1i,-1-1i,-1+1i,...
	+1+1i,-1+1i,-1+1i,+1+1i,-1-1i,-1-1i,-1-1i,+1-1i,-1-1i,-1+1i,+1-1i,-1-1i,-1-1i,-1-1i,+1+1i,+1+1i,...
	-1+1i,+1-1i,+1+1i,+1+1i,-1+1i,+1+1i,-1-1i,-1-1i,-1-1i,+1-1i,+1-1i,-1+1i,-1+1i,-1+1i,-1-1i,-1+1i,...
	+1+1i,+1-1i,+1-1i,+1-1i,-1-1i,+1-1i,+1+1i,+1+1i,-1+1i,+1-1i,+1-1i,+1-1i,+1-1i,+1+1i,-1-1i,-1+1i,...
	+1+1i,+1-1i,+1+1i,-1+1i,-1-1i,-1+1i,+1-1i,+1+1i,+1-1i,-1+1i,+1+1i,-1+1i,+1+1i,-1+1i,+1-1i,+1+1i,...
	+1-1i,-1-1i,-1+1i,+1+1i,-1+1i,-1+1i,+1+1i,-1+1i,+1-1i,+1-1i,-1+1i,-1-1i,-1-1i,-1+1i,+1-1i,-1+1i,...
	-1+1i,+1+1i,-1+1i,-1+1i,+1+1i,+1-1i,-1+1i,+1+1i,+1+1i,+1+1i,-1+1i,+1-1i,-1+1i,-1-1i,-1-1i,+1+1i,...
	+1+1i,-1+1i,-1-1i,-1-1i,-1-1i,-1+1i,-1-1i,-1+1i,-1+1i,-1+1i,-1+1i,-1-1i,-1+1i,-1+1i,+1-1i,-1-1i,...
	+1+1i,+1-1i,-1+1i,+1+1i,+1+1i,+1-1i,+1-1i,-1-1i,+1-1i,+1+1i,+1-1i,-1-1i,+1+1i,+1+1i,-1+1i,+1+1i,...
	+1-1i,-1+1i,-1+1i,-1+1i,-1+1i,-1-1i,-1+1i,+1-1i,-1+1i,+1-1i,-1+1i,+1+1i,+1+1i,-1-1i,+1-1i,-1-1i,...
	+1-1i,+1+1i,-1+1i,-1+1i,-1-1i,+1+1i,-1+1i,+1+1i,+1+1i,+1-1i,-1-1i,-1-1i,-1-1i,-1-1i,+1+1i,+1+1i,...
	+1-1i,-1-1i,+1-1i,+1-1i,+1+1i,+1-1i,+1-1i,+1+1i,-1+1i,-1+1i,-1-1i,+1-1i,-1-1i,+1+1i,-1-1i,+1+1i,...
	-1+1i,+1+1i,-1-1i,+1+1i,-1+1i,-1-1i,+1-1i,+1-1i,+1+1i,+1+1i,+1+1i,+1-1i,+1+1i,-1-1i,+1+1i,+1+1i,...
	+1-1i,+1+1i,+1+1i,+1-1i,-1-1i,+1-1i,-1-1i,+1-1i,-1-1i,-1-1i,-1+1i,-1+1i,+1-1i,-1+1i,+1-1i,-1+1i,...
	-1+1i,+1+1i,+1-1i,+1-1i,-1-1i,+1-1i,+1+1i,+1-1i,+1-1i,-1+1i,-1-1i,+1-1i,+1+1i,+1+1i,+1+1i,+1+1i,...
	+1+1i,+1-1i,-1+1i,-1+1i,+1-1i,+1-1i,-1+1i,-1+1i,-1+1i,+1+1i,+1-1i,-1+1i,+1-1i,-1+1i,-1+1i,-1+1i,...
	+1+1i,-1+1i,+1+1i,-1+1i,-1-1i,+1-1i,+1-1i,+1-1i,-1-1i,-1+1i,+1+1i,+1-1i,+1-1i,-1-1i,+1+1i,+1+1i,...
	+1+1i,+1+1i,+1+1i,-1-1i,+1-1i,+1-1i,+1+1i,+1+1i,+1-1i,+1-1i,+1-1i,-1-1i,-1+1i,+1-1i,-1-1i,+1+1i,...
	+1+1i,+1+1i,-1+1i,-1+1i,+1-1i,+1+1i,+1+1i,+1+1i,+1+1i,-1+1i,-1+1i,-1-1i,-1+1i,-1-1i,-1-1i,-1-1i,...
	-1-1i,+1+1i,-1+1i,+1-1i,+1+1i,+1-1i,+1+1i,+1-1i,+1+1i,+1+1i,-1-1i,-1-1i,+1+1i,-1-1i,+1-1i,+1+1i,...
	-1-1i,-1-1i,-1-1i,-1+1i,+1+1i,+1+1i,+1+1i,+1-1i,-1-1i,+1+1i,-1-1i,+1+1i,+1-1i,-1+1i,-1+1i,-1-1i,...
	-1-1i,+1-1i,+1-1i,-1-1i,+1-1i,-1+1i,-1-1i,+1-1i,-1-1i,+1-1i,+1-1i,+1-1i,-1+1i,-1-1i,-1+1i,-1+1i,...
	-1-1i,-1+1i,+1-1i,-1+1i,-1+1i,+1+1i,+1+1i,-1+1i,+1+1i,-1+1i,+1+1i,-1+1i,+1+1i,+1-1i,-1-1i,+1+1i,...
	-1+1i,-1+1i,+1+1i,+1+1i,+1+1i,+1+1i,-1-1i,-1-1i,+1-1i,-1-1i,-1+1i,+1+1i,-1+1i,-1+1i,-1-1i,+1-1i,...
	+1-1i,-1+1i,+1-1i,+1+1i,+1-1i,+1+1i,-1+1i,+1+1i,-1-1i,+1-1i,-1-1i,+1-1i,+1+1i,-1-1i,-1+1i,+1-1i,...
	-1+1i,-1+1i,-1+1i,+1+1i,+1+1i,+1+1i,+1-1i,+1-1i,+1+1i,+1+1i,-1+1i,-1-1i,+1-1i,-1+1i,+1-1i,+1+1i,...
	-1+1i,+1+1i,+1-1i,+1+1i,+1-1i,+1-1i,+1-1i,+1-1i,-1+1i,+1-1i,-1-1i,+1+1i,+1+1i,-1+1i,-1+1i,+1-1i,...
	-1-1i,+1-1i,+1-1i,+1-1i,-1-1i,+1-1i,+1-1i,+1+1i,+1-1i,+1-1i,-1+1i,-1-1i,-1+1i,-1+1i,+1-1i,-1+1i,...
	-1-1i,+1-1i,+1+1i,+1-1i,-1-1i,-1+1i,-1-1i,+1+1i,-1-1i,-1-1i,-1-1i,-1+1i,-1-1i,-1-1i,-1-1i,-1-1i,...
	-1-1i,-1+1i,+1-1i,-1+1i,-1-1i,+1-1i,+1+1i,-1+1i,+1-1i,-1+1i,-1+1i,+1+1i,+1-1i,-1-1i,-1-1i,-1+1i,...
	-1-1i,-1+1i,+1-1i,-1-1i,+1-1i,-1-1i,-1+1i,+1-1i,-1+1i,+1-1i,-1-1i,-1+1i,-1-1i,-1-1i,-1-1i,+1-1i,...
	+1-1i,+1+1i,-1+1i,-1+1i,-1+1i,-1+1i,+1+1i,+1-1i,-1-1i,-1+1i,+1-1i,+1-1i,-1+1i,-1-1i,-1+1i,+1-1i,...
	+1-1i,+1-1i,+1-1i,-1-1i,-1+1i,+1+1i,-1+1i,+1+1i,-1-1i,+1-1i,+1+1i,+1+1i,-1-1i,-1-1i,-1-1i,+1+1i,...
	+1+1i,-1-1i,-1-1i,+1-1i,+1+1i,+1-1i,-1+1i,+1+1i,+1+1i,-1-1i,+1+1i,-1+1i,-1+1i,+1+1i,-1+1i,+1+1i,...
	-1-1i,-1+1i,+1-1i,-1+1i,+1-1i,+1-1i,-1-1i,-1-1i,-1+1i,-1+1i,+1-1i,-1+1i,-1+1i,+1+1i,-1-1i,+1-1i,...
	+1-1i,-1+1i,+1-1i,-1-1i,-1-1i,-1+1i,-1+1i,+1-1i,-1+1i,+1+1i,+1+1i,-1+1i,-1+1i,+1+1i,-1+1i,-1-1i,...
	+1-1i,-1+1i,+1-1i,-1+1i,+1+1i,+1-1i,-1-1i,+1+1i,+1-1i,-1+1i,+1+1i,+1-1i,-1+1i,+1-1i,+1-1i,+1-1i,...
	+1+1i,-1+1i,-1+1i,+1-1i,+1+1i,-1+1i,-1-1i,+1+1i,+1+1i,-1-1i,+1-1i,-1-1i,+1-1i,+1-1i,+1+1i,+1-1i,...
	-1-1i,-1-1i,-1-1i,+1+1i,+1-1i,+1-1i,+1-1i,+1+1i,-1+1i,-1-1i,+1+1i,+1-1i,+1+1i,+1-1i,-1-1i,+1-1i,...
	+1-1i,-1-1i,+1-1i,+1+1i,-1-1i,+1+1i,+1+1i,+1-1i,-1-1i,-1-1i,+1+1i,-1+1i,-1+1i,-1+1i,-1+1i,+1-1i,...
	-1+1i,+1+1i,+1+1i,+1-1i,-1+1i,-1-1i,-1-1i,-1+1i,-1-1i,+1+1i,+1-1i,+1-1i,+1+1i,-1+1i,+1+1i,+1+1i,...
	+1-1i,+1-1i,+1-1i,-1+1i,-1+1i,+1+1i,+1-1i,-1+1i,-1+1i,+1-1i,-1-1i,+1-1i,-1-1i,+1-1i,-1-1i,+1-1i,...
	+1+1i,-1-1i,-1-1i,-1-1i,-1+1i,-1+1i,-1-1i,-1-1i,-1-1i,-1-1i,-1-1i,+1+1i,+1-1i,+1+1i,-1-1i,-1-1i,...
	-1-1i,-1+1i,+1-1i,+1-1i,-1+1i,+1-1i,-1-1i,-1+1i,+1+1i,+1+1i,-1+1i,-1+1i,+1+1i,+1+1i,+1-1i,+1+1i,...
	+1-1i,-1-1i,-1-1i,-1+1i,-1-1i,+1+1i,-1+1i,-1+1i,+1-1i,-1+1i,-1+1i,+1+1i,-1-1i,+1-1i,+1-1i,+1+1i,...
	+1-1i,+1+1i,+1+1i,+1-1i,-1-1i,-1-1i,+1+1i,+1-1i,-1+1i,-1+1i,-1-1i,-1+1i,+1+1i,-1+1i,-1-1i,+1-1i,...
	+1+1i,+1+1i,+1-1i,+1-1i,-1-1i,+1+1i,+1+1i,-1-1i,-1-1i,+1+1i,+1+1i,-1-1i,-1-1i,-1-1i,-1+1i,+1+1i,...
	+1-1i,+1+1i,-1+1i,-1-1i,-1-1i,+1+1i,+1-1i,-1+1i,+1+1i,-1+1i,+1+1i,+1-1i,+1-1i,-1+1i,+1+1i,+1-1i,...
	+1+1i,+1+1i,+1-1i,-1-1i,-1-1i,+1-1i,+1-1i,+1-1i,-1+1i,-1+1i,-1-1i,+1+1i,-1+1i,+1+1i,+1-1i,-1+1i,...
	-1+1i,-1+1i,-1+1i,-1+1i,-1-1i,-1-1i,-1+1i,-1+1i,-1+1i,-1+1i,-1+1i,+1+1i,-1+1i,-1-1i,-1-1i,-1+1i]...
    / sqrt(2);



%% OFDM Parameters
ofdmc.nCarriers            = 1024;
ofdmc.cpLength             = 20;
ofdmc.nDataOFDMSymbols     = 30; % No. data symbols
ofdmc.nTrainingOFDMSymbols = 1;  % No. training symbols before data symbols
ofdmc.nOFDMSymbols         = ofdmc.nDataOFDMSymbols ...
	+ ofdmc.nTrainingOFDMSymbols;

% PSD mask to not use highly noise carriers
ofdmc.psdMask              = ones(1024,1);
ofdmc.psdMask(1:100)       = 0;  % DC Carriers
ofdmc.psdMask(417:607)     = 0;  % Edges of the spectrum
ofdmc.psdMask(926:1024)    = 0;  % DC Carriers
ofdmc.psdMask              = logical(ofdmc.psdMask);

ofdmc.nUsefulCarriers      = sum(ofdmc.psdMask);

ofdmc.pilotIndices         = [101,925];
ofdmc.pilotSymbols         = ofdmc.fullTrainingSymbol(ofdmc.pilotIndices);

% DATA mask indicates where we have data carriers
ofdmc.dataMask             = ofdmc.psdMask;
ofdmc.dataMask(ofdmc.pilotIndices) ...
                           = 0;
ofdmc.dataMask             = logical(ofdmc.dataMask);

ofdmc.trainingSymbols      = ofdmc.fullTrainingSymbol(ofdmc.psdMask);
ofdmc.nZeros               = 0; % 2*(ofdmc.nCarriers+ofdmc.cpLength); % for noise estimation

%% Data Modulation
ofdmc.constellationType    = 'qam'; % constellation type ('qam' or 'psk')
ofdmc.M                    = 4;     % modulation order
ofdmc.nDataBits            = ofdmc.nDataOFDMSymbols * ...  
	(ofdmc.nUsefulCarriers - numel(ofdmc.pilotIndices)) * ...  
	log2(ofdmc.M);              % total number of data bits we can transmit
ofdmc.nTextBits            = 37632; % text bits: hardcoded to the text file we have. 
% We use it at Rx in order to avoid printing garbage after the useful text
% (we pad the text with random bits to match the length of the OFDM blocks).

%% Computed Parameters
% 1. Total length of TX signal
ofdmc.txSignalLength = numel(ofdmc.preamble) + ...  
	ofdmc.nZeros + ... 
	ofdmc.nOFDMSymbols * (ofdmc.nCarriers + ofdmc.cpLength);
% 2. Sampling period
global usrpc;
if isempty(usrpc)
    usrpConfig();
end

ofdmc.T              = usrpc.Ts; % [s] 
% 3. The precision of CFO estimation
ofdmc.fCorr          = 0.1/(ofdmc.T*numel(ofdmc.preamble));    % [Hz] 
ofdmc.rangeCFO       = -1200:ofdmc.fCorr:1200;                 % [Hz] (Usually the CFO is not more than 1.2kHz)

if (ofdmc.verbose) 
	fprintf('The Doppler step is %g [Hz].\n', ofdmc.fCorr);
end
end



