import numpy as np
import matplotlib.pyplot as plt
import utilMDC
import utilPDC
from scipy import special

# basic script to plot the eye diagram

# Define parameters
nsymbols = int(1e4)
M = int(4)  # 4-ary qam
bitsPerSymb = int(np.log2(M))
nbits = int(nsymbols * bitsPerSymb)
beta = 0.22
SPAN = int(16)
T = 1  # s
SPS = int(50)
Fs = SPS/T
ch_delay = int(10)  # delay in multiples of Ts
SNR_dB = 20  # dB

# create the bits (0/1 values)
bits = np.random.randint(2, size=nbits)

# create the symbols (sol_bi2de, sol_qamMap, sol_encoder)
MaryData = utilPDC.sol_bi2de(np.reshape(bits, (nsymbols, bitsPerSymb)))
# encode
map = utilPDC.sol_qamMap(M)
symbols = utilPDC.sol_encoder(MaryData, map)

# map symbols to samples (rcosdesign + sol_symbols2samples)
h = utilPDC.sol_rcosdesign(beta, SPAN, SPS)
# the pulse is already normalized
samples = utilPDC.sol_symbols2samples(symbols, h, SPS)

# noiseless channel with delay
samples = np.concatenate((np.zeros(ch_delay), samples), axis = None) # introduce the delay
# find the signal energy per symbol
Es = np.var(symbols)
# find the noise variance sigma2 so that 10*log_10(Es/sigma2) = SNR_dB
sigma2 = Es/(10 ** (SNR_dB/10))
sigma = np.sqrt(sigma2)
# create the sample-level noise vector
noise = (sigma/np.sqrt(2))*np.random.randn(np.size(samples)) + 1j*(sigma/np.sqrt(2))*np.random.randn(np.size(samples))
actual_SNR = 10*np.log10(np.var(symbols)/np.var(noise))
print('The obtained SNR is: %s [dB]', actual_SNR)  # test that we get back SNR
# create the channel output
received = samples + noise

# generate the sufficient statistics (sol_sufficientStatistics)
suffStat, mfOutput = utilPDC.sol_sufficientStatistics(received, h, SPS)

# plot the eye diagram
utilPDC.sol_eyediagram(mfOutput.real, Fs, T)
plt.title('Eye Diagram - real component')
plt.show()
utilPDC.sol_eyediagram(mfOutput.imag, Fs, T)
plt.title('Eye Diagram - imag component')
plt.show()

# plot the received constellation (output of the MF)
plt.scatter(suffStat.real, suffStat.imag, marker='*')
plt.ylabel('Imaginary')
plt.xlabel('Real')
plt.title('Received constellation at the output of the MF')
plt.grid()
plt.show()
