function Rf = my_ofdm_rx_frame(rx_symbols, num_carriers, psd_mask, prefix_length)
% MY_OFDM_RX_FRAME Receiver for ODFM signals (without channel equalization)
%  RF = MY_OFDM_RX_FRAME(RX_SYMBOLS, NUM_CARRIERS, PSD_MASK, PREFIX_LENGTH)
%
%       RX_SYMBOLS: vector of channel outputs. It is a filtered and noisy
%       version of the transmitted symbols. 
%       NUM_CARRIERS: number of carriers per OFDM block (power of 2). The
%       same as in OFDM_TX_FRAME.
%       PSD_MASK: A {0,1}-valued vector of length NUM_CARRIERS. The same 
%       as in OFDM_TX_FRAME.
%       PREFIX_LENGTH: cyclic-prefix length (in number of samples). The
%       same as in OFDM_TX_FRAME.
%
%   RF: Matrix of TRAINING_SYMBOLS and DATA_SYMBOLS (see OFDM_TX_FRAME) as
%   seen at the output of the equivalent "parallel channels" created by
%   OFDM. To obtain the RF matrix, we start by rearranging the received
%   symbols columnwise in a matrix that has (NUM_CARRIERS + PREFIX_LENGTH)
%   rows. In doing so, we remove the tail of RX_SYMBOLS that don't fill an
%   entire column. Then we remove the cyclic prefix and take the FFT.
%   Finally, the symbols that correspond to unused carriers are removed.
