import numpy as np
import matplotlib.pyplot as plt
import utilMDC
import utilPDC

# Parameters
USF = 10  # upsampling factor(number of samples per symbol)

# We need to truncate the infinite impulse response of the RRC filter
# to approximate it by a FIR filter
span = 20  # length of the truncated pulse is specified in terms of
# the number of symbols

beta = 0.8  # roll - off factor
# change this to 0, 0.5 and 1.0(for instance) and observe the effect on
# both the impulse and frequency response

# Filter design
h = utilPDC.sol_rcosdesign(beta, span, USF)  # here the filter is already normalized to norm 1

# Results

Fd = 1  # symbol rate
Fs = USF * Fd  # sampling frequency
utilMDC.tfplot(h, Fs, 'h', 'RRC impulse response, beta = %s' % beta)
