import numpy as np
import warnings
import scipy.io
import scipy.io.wavfile as siow
from scipy import signal
import matplotlib.pyplot as plt

import utilMDC

def my_ammod(m, K, A, fc, fs):
    """
    Performs amplitude modulation.
    S = MY_AMMOD(M, K, A, Fc, Fs) is an amplitude modulated signal of the
    message signal M(t), where Fs is the sampling frequency of the message
    signal and Fc is the desired carrier frequency. The modulation is
    performed as follows:
    S = A * (1 + K*M(t)) * cos(2*pi*Fc*t)

    :param m: message signal
    :param K: as in the formula above
    :param A: as in the formula above
    :param fc: the desired carrier frequency
    :param fs: the sampling frequency of the message signal
    :return: the amplitude modulated signal of the message signal M(t)
    """

    # Compute the modulated signal
    s =

    return s


def my_amdemod(s, fc, fs):
    """
    Demodulate AM signal (with the moving average method discussed in class).
    MD = MY_AMDEMOD(S, FC, FS) is the demodulation of an AM
    (amplitude modulation) signal at carrier frequency FC, sampled at FS.
    The returned signal is normalized to have values between -1 and 1.

    :param s: the AM signal
    :param fc: the carrier frequency
    :param fs: the sampling frequency
    :return: the demodulated signal, normalized to have values between -1 and 1
    """

    md =

    return md

# =======================================
# my_test_am()
# Tests the AM modulator and demodulator with an audible signal.
# Alternative values are given (commented) for playing a more audible signal (440Hz)

# Define signal parameters

Finfo  = 10     # 440;  % Message signal frequency [Hz]
Fc     = 300    # 40e3; % Carrier frequency [Hz]
A      = 1      # Modulation constant
K      = 1      # Modulation constant
Fs     = 4000   # 1000e3; % Sampling frequency [Hz]
d      = 1      # Signal duration [s]
DownSample = 1  # 30

# Time vector


# Create the message signal and its modulated signal


# Plot both the message signal and the modulated signal


# Demodulate the AM signal and plot again


# Play the signals and display status messages
print("Playing original signal\n")
siow.write("originalSignal.wav", Fs // DownSample, m[::DownSample])
# playsound.playsound("originalSignal.wav", block=False)
print("Playing recovered signal\n")
siow.write("recoveredSignal.wav", Fs // DownSample, m_est[::DownSample])
# playsound.playsound("recoveredSignal.wav", block=False)

# =======================================
# demodulate and save/play the audio file

# my_play_am()
# This script demodulates and plays the AM signal stored in am_signal.mat.

# Downsampling factor as in the Hw statement
downsamplingFactor = 10

# Load the samples, fc and fs from file
data = scipy.io.loadmat('am_data.mat')
fs, fc = int(data["fs"]), float(data["fc"])
m_am = data["am_signal"].flatten()  # flatten the array

# Demodulate and play


track_file = "track.wav"
siow.write(track_file, fs // downsamplingFactor, m[::downsamplingFactor])
# playsound.playsound(track_file, block=False)
