% SOL_AMDEMOD Demodulate AM signal
%    MD = SOL_AMDEMOD(S, FC, FS) is the demodulation of an AM
%    (amplitude modulation) signal at carrier frequency FC, sampled at FS.
%    The returned signal is normalized to have values between -1 and 1.

function md = sol_amdemod(s, fc, fs)
      
    % Take absolute value
    s_abs = abs(s);
    
    k = round(10*fs/fc); % we are getting the moving average over 10 carrier periods
    s_env = movmean(s_abs,k);
    s_zm = s_env - mean(s_env); % making it zero-mean
    
    % Convert to be between -1 and 1 
    md = s_zm / max(abs(s_zm));
   
end
